/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.HydraMortarModel;
import twilightforest.entity.boss.HydraMortarHead;

public class HydraMortarRenderer
extends EntityRenderer<HydraMortarHead> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("hydramortar.png");
    private final HydraMortarModel mortarModel = new HydraMortarModel();

    public HydraMortarRenderer(EntityRendererManager manager) {
        super(manager);
        this.field_76989_e = 0.5f;
    }

    public void render(HydraMortarHead mortar, float yaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffers, int light) {
        stack.func_227860_a_();
        if ((float)mortar.fuse - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)mortar.fuse - partialTicks + 1.0f) / 10.0f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            stack.func_227862_a_(f1, f1, f1);
        }
        float alpha = (1.0f - ((float)mortar.fuse - partialTicks + 1.0f) / 100.0f) * 0.8f;
        IVertexBuilder builder = buffers.getBuffer(this.mortarModel.func_228282_a_(textureLoc));
        this.mortarModel.func_225598_a_(stack, builder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.075f);
        if (mortar.fuse / 5 % 2 == 0) {
            builder = buffers.getBuffer(RenderType.func_228644_e_((ResourceLocation)textureLoc));
            this.mortarModel.func_225598_a_(stack, builder, light, OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)1.0f), (int)10), 1.0f, 1.0f, 1.0f, alpha);
        }
        stack.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(HydraMortarHead entity) {
        return textureLoc;
    }
}

