/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.IWeatherRenderHandler;
import twilightforest.TwilightForestMod;
import twilightforest.world.TFGenerationSettings;
import twilightforest.worldgen.biomes.BiomeKeys;

public class TFWeatherRenderer
implements IWeatherRenderHandler {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation SPARKLES_TEXTURE = TwilightForestMod.getEnvTexture("sparkles.png");
    private final float[] rainxs = new float[1024];
    private final float[] rainzs = new float[1024];
    private int rendererUpdateCount;
    private MutableBoundingBox protectedBox;
    private final Random random = new Random();

    public TFWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainxs[i << 5 | j] = -f1 / f2;
                this.rainzs[i << 5 | j] = f / f2;
            }
        }
    }

    public void tick() {
        ++this.rendererUpdateCount;
    }

    public void render(int ticks, float partialTicks, ClientWorld world, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        this.renderNormalWeather(lightmap, world, mc, partialTicks, xIn, yIn, zIn);
        if (TFGenerationSettings.isProgressionEnforced((World)world) && !mc.field_71439_g.func_184812_l_() && !mc.field_71439_g.func_175149_v()) {
            this.renderLockedBiome(partialTicks, world, mc, lightmap, xIn, yIn, zIn);
            this.renderLockedStructure(partialTicks, mc, lightmap, xIn, yIn, zIn);
        }
    }

    private void renderNormalWeather(LightTexture lightmapIn, ClientWorld world, Minecraft mc, float partialTicks, double xIn, double yIn, double zIn) {
        float f = world.func_72867_j(partialTicks);
        if (!(f <= 0.0f)) {
            lightmapIn.func_205109_c();
            int i = MathHelper.func_76128_c((double)xIn);
            int j = MathHelper.func_76128_c((double)yIn);
            int k = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int l = 5;
            if (Minecraft.func_71375_t()) {
                l = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            int i1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainxs[l1] * 0.5;
                    double d1 = (double)this.rainzs[l1] * 0.5;
                    blockpos$mutable.func_181079_c(k1, 0, j1);
                    Biome biome = world.func_226691_t_((BlockPos)blockpos$mutable);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int i2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutable).func_177956_o();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = Math.max(i2, j);
                    if (j2 == k2) continue;
                    Random random = new Random((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L);
                    blockpos$mutable.func_181079_c(k1, j2, j1);
                    float f2 = biome.func_225486_c((BlockPos)blockpos$mutable);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            i1 = 0;
                            mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = this.rendererUpdateCount + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)k1 + 0.5f) - xIn;
                        double d4 = (double)((float)j1 + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutable.func_181079_c(k1, l2, j1);
                        int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        i1 = 1;
                        mc.func_110434_K().func_110577_a(SNOW_TEXTURES);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float f6 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)((float)k1 + 0.5f) - xIn;
                    double d5 = (double)((float)j1 + 0.5f) - zIn;
                    float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutable.func_181079_c(k1, l2, j1);
                    int k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = (k3 & 0xFFFF) * 3;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                }
            }
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmapIn.func_205108_b();
        }
    }

    private void renderLockedBiome(float partialTicks, ClientWorld wc, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        if (this.isNearLockedBiome((World)wc, mc.func_175606_aa())) {
            lightmap.func_205109_c();
            Entity entity = mc.func_175606_aa();
            ClientWorld world = mc.field_71441_e;
            int x0 = MathHelper.func_76128_c((double)xIn);
            int y0 = MathHelper.func_76128_c((double)yIn);
            int z0 = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int range = 5;
            if (Minecraft.func_71375_t()) {
                range = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            Enum currentType = null;
            float combinedTicks = (float)this.rendererUpdateCount + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
            for (int z = z0 - range; z <= z0 + range; ++z) {
                block7: for (int x = x0 - range; x <= x0 + range; ++x) {
                    int idx = (z - z0 + 16) * 32 + x - x0 + 16;
                    double rx = (double)this.rainxs[idx] * 0.5;
                    double ry = (double)this.rainzs[idx] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(x, 0, z);
                    Biome biome = world.func_226691_t_((BlockPos)blockpos$mutableblockpos);
                    if (TFGenerationSettings.isBiomeSafeFor(biome, entity)) continue;
                    int groundY = 0;
                    int minY = y0 - range;
                    int maxY = y0 + range;
                    if (minY < groundY) {
                        minY = groundY;
                    }
                    if (maxY < groundY) {
                        maxY = groundY;
                    }
                    int y = Math.max(groundY, y0);
                    if (minY == maxY) continue;
                    this.random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L);
                    RenderType nextType = this.getRenderType(biome);
                    if (nextType == null) continue;
                    if (currentType != nextType) {
                        if (currentType != null) {
                            tessellator.func_78381_a();
                        }
                        currentType = nextType;
                        mc.func_110434_K().func_110577_a(nextType.getTextureLocation());
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    switch (1.$SwitchMap$twilightforest$client$renderer$TFWeatherRenderer$RenderType[currentType.ordinal()]) {
                        case 1: 
                        case 2: {
                            float d5 = -((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                            double d6 = (double)((float)x + 0.5f) - xIn;
                            double d7 = (double)((float)z + 0.5f) - zIn;
                            float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)range;
                            float f4 = (1.0f - f3 * f3) * 0.5f + 0.5f;
                            blockpos$mutableblockpos.func_181079_c(x, y, z);
                            int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutableblockpos);
                            int k3 = j3 >> 16 & 0xFFFF;
                            int l3 = j3 & 0xFFFF;
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f, (float)minY * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f, (float)minY * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f, (float)maxY * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f, (float)maxY * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                            continue block7;
                        }
                        case 3: {
                            float d8 = 0.0f;
                            float d9 = this.random.nextFloat() + combinedTicks * 0.01f * (float)this.random.nextGaussian();
                            float d10 = this.random.nextFloat() + combinedTicks * (float)this.random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)range;
                            float r = this.random.nextFloat() * 0.3f;
                            float g = this.random.nextFloat() * 0.3f;
                            float b = this.random.nextFloat() * 0.3f;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f + d9, (float)minY * 0.25f + d8 + d10).func_227885_a_(r, g, b, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f + d9, (float)minY * 0.25f + d8 + d10).func_227885_a_(r, g, b, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).func_227885_a_(r, g, b, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).func_227885_a_(r, g, b, f5).func_225587_b_(j4, k4).func_181675_d();
                            continue block7;
                        }
                        case 4: {
                            float d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = this.random.nextFloat() + combinedTicks * 0.01f * (float)this.random.nextGaussian();
                            float d10 = this.random.nextFloat() + combinedTicks * (float)this.random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)range;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            float color = this.random.nextFloat() * 0.2f + 0.8f;
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f + d9, (float)minY * 0.25f + d8 + d10).func_227885_a_(color, color, color, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f + d9, (float)minY * 0.25f + d8 + d10).func_227885_a_(color, color, color, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).func_227885_a_(color, color, color, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).func_227885_a_(color, color, color, f5).func_225587_b_(j4, k4).func_181675_d();
                            continue block7;
                        }
                        case 5: {
                            float d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = 0.0f;
                            float d10 = this.random.nextFloat() + combinedTicks * (float)this.random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)range;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * this.random.nextFloat();
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f + d9, (float)minY * 0.25f + d8 + d10).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f + d9, (float)minY * 0.25f + d8 + d10).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).func_225583_a_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_225587_b_(j4, k4).func_181675_d();
                            bufferbuilder.func_225582_a_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).func_225583_a_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_225587_b_(j4, k4).func_181675_d();
                        }
                    }
                }
            }
            if (currentType != null) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmap.func_205108_b();
        }
    }

    private void renderLockedStructure(float partialTicks, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        if (this.isNearLockedStructure(xIn, zIn)) {
            lightmap.func_205109_c();
            int i = MathHelper.func_76128_c((double)xIn);
            int j = MathHelper.func_76128_c((double)yIn);
            int k = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int i1 = 5;
            if (Minecraft.func_71375_t()) {
                i1 = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            int j1 = -1;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainzs[i2] * 0.5;
                    if (this.protectedBox == null || !this.protectedBox.func_78885_a(l1, k1, l1, k1)) continue;
                    int structureMin = this.protectedBox.field_78895_b - 4;
                    int structureMax = this.protectedBox.field_78894_e + 4;
                    int k2 = j - i1;
                    int l2 = j + i1 * 2;
                    if (k2 < structureMin) {
                        k2 = structureMin;
                    }
                    if (l2 < structureMin) {
                        l2 = structureMin;
                    }
                    if (k2 > structureMax) {
                        k2 = structureMax;
                    }
                    if (l2 > structureMax) {
                        l2 = structureMax;
                    }
                    if (k2 == l2) continue;
                    Random random = new Random((long)l1 * (long)l1 * 3121L + (long)l1 * 45238971L ^ (long)k1 * (long)k1 * 418711L + (long)k1 * 13761L);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    if (j1 != 0) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 0;
                        mc.func_110434_K().func_110577_a(SPARKLES_TEXTURE);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float d5 = -((float)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                    double d6 = (double)((float)l1 + 0.5f) - xIn;
                    double d7 = (double)((float)k1 + 0.5f) - zIn;
                    float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                    float f = random.nextFloat();
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    int j3 = 0xF000F0;
                    int k3 = j3 >> 16 & 0xFFFF;
                    int l3 = j3 & 0xFFFF;
                    bufferbuilder.func_225582_a_((double)l1 - xIn - d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn - d4 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                    bufferbuilder.func_225582_a_((double)l1 - xIn + d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn + d4 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                    bufferbuilder.func_225582_a_((double)l1 - xIn + d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn + d4 + 0.5).func_225583_a_(1.0f, (float)l2 * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                    bufferbuilder.func_225582_a_((double)l1 - xIn - d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn - d4 + 0.5).func_225583_a_(0.0f, (float)l2 * 0.25f + d5).func_227885_a_(1.0f, 1.0f, 1.0f, f4).func_225587_b_(k3, l3).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmap.func_205108_b();
        }
    }

    private boolean isNearLockedBiome(World world, Entity viewEntity) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int range = 15;
        int px = MathHelper.func_76128_c((double)viewEntity.func_226277_ct_());
        int pz = MathHelper.func_76128_c((double)viewEntity.func_226281_cx_());
        for (int z = pz - 15; z <= pz + 15; ++z) {
            for (int x = px - 15; x <= px + 15; ++x) {
                Biome biome = world.func_226691_t_((BlockPos)pos.func_181079_c(x, 0, z));
                if (TFGenerationSettings.isBiomeSafeFor(biome, viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNearLockedStructure(double xIn, double zIn) {
        int range = 15;
        int px = MathHelper.func_76128_c((double)xIn);
        int pz = MathHelper.func_76128_c((double)zIn);
        return this.protectedBox != null && this.protectedBox.func_78885_a(px - 15, pz - 15, px + 15, pz + 15);
    }

    public void setProtectedBox(MutableBoundingBox protectedBox) {
        this.protectedBox = protectedBox;
    }

    private RenderType getRenderType(Biome b) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return null;
        }
        ResourceLocation biome = Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)b);
        if (BiomeKeys.SNOWY_FOREST.func_240901_a_().equals((Object)biome) || BiomeKeys.GLACIER.func_240901_a_().equals((Object)biome)) {
            return RenderType.BLIZZARD;
        }
        if (BiomeKeys.SWAMP.func_240901_a_().equals((Object)biome)) {
            return RenderType.MOSQUITO;
        }
        if (BiomeKeys.FIRE_SWAMP.func_240901_a_().equals((Object)biome)) {
            return RenderType.ASHES;
        }
        if (BiomeKeys.DARK_FOREST.func_240901_a_().equals((Object)biome) || BiomeKeys.DARK_FOREST_CENTER.func_240901_a_().equals((Object)biome)) {
            return this.random.nextInt(2) == 0 ? RenderType.DARK_STREAM : null;
        }
        if (BiomeKeys.HIGHLANDS.func_240901_a_().equals((Object)biome) || BiomeKeys.THORNLANDS.func_240901_a_().equals((Object)biome) || BiomeKeys.FINAL_PLATEAU.func_240901_a_().equals((Object)biome)) {
            return RenderType.BIG_RAIN;
        }
        return null;
    }

    private static enum RenderType {
        BLIZZARD("blizzard.png"),
        MOSQUITO("mosquitoes.png"),
        ASHES("ashes.png"),
        DARK_STREAM("darkstream.png"),
        BIG_RAIN("bigrain.png");

        private final ResourceLocation textureLocation;

        private RenderType(String textureName) {
            this.textureLocation = TwilightForestMod.getEnvTexture(textureName);
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }
    }
}

