/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.entity.SlideBlockEntity;
import twilightforest.entity.TFEntities;
import twilightforest.util.TFDamageSources;

public class SliderBlock
extends RotatedPillarBlock
implements IWaterLoggable {
    public static final IntegerProperty DELAY = IntegerProperty.func_177719_a((String)"delay", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final int TICK_TIME = 80;
    private static final int OFFSET_TIME = 20;
    private static final int PLAYER_RANGE = 32;
    private static final float BLOCK_DAMAGE = 5.0f;
    private static final VoxelShape Y_BB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875));
    private static final VoxelShape Z_BB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0));
    private static final VoxelShape X_BB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875));

    protected SliderBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151664_l).func_200948_a(2.0f, 10.0f).func_200944_c().func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176298_M, (Comparable)Direction.Axis.Y)).func_206870_a((Property)DELAY, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DELAY, WATERLOGGED});
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b((Property)field_176298_M)) {
            default: {
                return Y_BB;
            }
            case X: {
                return X_BB;
            }
            case Z: 
        }
        return Z_BB;
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K && this.isConnectedInRange((World)world, pos)) {
            SlideBlockEntity slideBlock = new SlideBlockEntity(TFEntities.slider, (World)world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state);
            world.func_217376_c((Entity)slideBlock);
        }
        this.scheduleBlockUpdate((World)world, pos);
    }

    public boolean isConnectedInRange(World world, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)world.func_180495_p(pos).func_177229_b((Property)field_176298_M);
        switch (axis) {
            case Y: {
                return this.anyPlayerInRange(world, pos) || this.isConnectedInRangeRecursive(world, pos, Direction.UP) || this.isConnectedInRangeRecursive(world, pos, Direction.DOWN);
            }
            case X: {
                return this.anyPlayerInRange(world, pos) || this.isConnectedInRangeRecursive(world, pos, Direction.WEST) || this.isConnectedInRangeRecursive(world, pos, Direction.EAST);
            }
            case Z: {
                return this.anyPlayerInRange(world, pos) || this.isConnectedInRangeRecursive(world, pos, Direction.NORTH) || this.isConnectedInRangeRecursive(world, pos, Direction.SOUTH);
            }
        }
        return this.anyPlayerInRange(world, pos);
    }

    private boolean isConnectedInRangeRecursive(World world, BlockPos pos, Direction dir) {
        BlockPos dPos = pos.func_177972_a(dir);
        if (world.func_180495_p(pos) == world.func_180495_p(dPos)) {
            return this.anyPlayerInRange(world, dPos) || this.isConnectedInRangeRecursive(world, dPos, dir);
        }
        return false;
    }

    private boolean anyPlayerInRange(World world, BlockPos pos) {
        return world.func_217366_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 32.0, false) != null;
    }

    public void scheduleBlockUpdate(World world, BlockPos pos) {
        int offset = (Integer)world.func_180495_p(pos).func_177229_b((Property)DELAY);
        int update = 80 - (int)(world.func_82737_E() - (long)(offset * 20)) % 80;
        world.func_205220_G_().func_205360_a(pos, (Object)this, update);
    }

    @Deprecated
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.scheduleBlockUpdate(world, pos);
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        entity.func_70097_a(TFDamageSources.SLIDER, 5.0f);
        if (entity instanceof LivingEntity) {
            double kx = ((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_()) * 2.0;
            double kz = ((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_()) * 2.0;
            ((LivingEntity)entity).func_233627_a_(2.0f, kx, kz);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("twilightforest.misc.nyi"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

