/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.data.ItemTagGenerator;
import twilightforest.network.StructureProtectionClearPacket;
import twilightforest.network.StructureProtectionPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.StructureBoundingBoxUtils;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.world.TFGenerationSettings;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFTickHandler {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!(player.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)player.field_70170_p;
        if (!world.field_72995_K && !((Boolean)TFConfig.COMMON_CONFIG.disablePortalCreation.get()).booleanValue() && event.phase == TickEvent.Phase.END && player.field_70173_aa % ((Boolean)TFConfig.COMMON_CONFIG.checkPortalDestination.get() != false ? 100 : 20) == 0) {
            if (((Boolean)TFConfig.COMMON_CONFIG.adminOnlyPortals.get()).booleanValue()) {
                if (world.func_73046_m().func_211833_a(player.func_146103_bH()) != 0) {
                    TFTickHandler.checkForPortalCreation(player, (World)world, 4.0f);
                }
            } else {
                TFTickHandler.checkForPortalCreation(player, (World)world, 32.0f);
            }
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0 && TFGenerationSettings.isProgressionEnforced((World)world) && TFGenerationSettings.isTwilightChunk(world) && !player.func_184812_l_() && !player.func_175149_v()) {
            TFGenerationSettings.enforceBiomeProgression(player, (World)world);
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && player.field_70173_aa % 100 == 0 && TFGenerationSettings.isProgressionEnforced((World)world) && TFGenerationSettings.isTwilightChunk(world)) {
            if (player.func_184812_l_() || player.func_175149_v()) {
                TFTickHandler.sendAllClearPacket((World)world, player);
            } else {
                TFTickHandler.checkForLockedStructuresSendPacket(player, (World)world);
            }
        }
    }

    private static void sendStructureProtectionPacket(World world, PlayerEntity player, MutableBoundingBox sbb) {
        if (player instanceof ServerPlayerEntity) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new StructureProtectionPacket(sbb));
        }
    }

    private static void sendAllClearPacket(World world, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new StructureProtectionClearPacket());
        }
    }

    private static boolean checkForLockedStructuresSendPacket(PlayerEntity player, World world) {
        ChunkGeneratorTwilightBase chunkGenerator = TFGenerationSettings.getChunkGenerator(world);
        if (chunkGenerator == null) {
            return false;
        }
        return TFGenerationSettings.locateTFStructureInRange((ISeedReader)((ServerWorld)world), player.func_233580_cy_(), 100).map(structure -> {
            MutableBoundingBox fullSBB = structure.func_75071_a();
            Vector3i center = StructureBoundingBoxUtils.getCenter(fullSBB);
            TFFeature nearFeature = TFFeature.getFeatureForRegionPos(center.func_177958_n(), center.func_177952_p(), (ISeedReader)((ServerWorld)world));
            if (!nearFeature.hasProtectionAura || nearFeature.doesPlayerHaveRequiredAdvancements(player)) {
                TFTickHandler.sendAllClearPacket(world, player);
                return false;
            }
            TFTickHandler.sendStructureProtectionPacket(world, player, fullSBB);
            return true;
        }).orElse(false);
    }

    private static void checkForPortalCreation(PlayerEntity player, World world, float rangeToCheck) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)new ResourceLocation((String)TFConfig.COMMON_CONFIG.originDimension.get())) || world.func_234923_W_().func_240901_a_().toString().equals(TFConfig.COMMON_CONFIG.DIMENSION.twilightForestID.get()) || ((Boolean)TFConfig.COMMON_CONFIG.allowPortalsInOtherDimensions.get()).booleanValue()) {
            List itemList = world.func_217357_a(ItemEntity.class, player.func_174813_aQ().func_186662_g((double)rangeToCheck));
            for (ItemEntity entityItem : itemList) {
                if (!ItemTagGenerator.PORTAL_ACTIVATOR.func_230235_a_((Object)entityItem.func_92059_d().func_77973_b())) continue;
                BlockPos pos = new BlockPos(entityItem.func_213303_ch().func_178786_a(0.0, -0.1, 0.0));
                BlockState state = world.func_180495_p(pos);
                if (!((TFPortalBlock)TFBlocks.twilight_portal.get()).canFormPortal(state)) continue;
                Random rand = new Random();
                for (int i = 0; i < 2; ++i) {
                    double vx = rand.nextGaussian() * 0.02;
                    double vy = rand.nextGaussian() * 0.02;
                    double vz = rand.nextGaussian() * 0.02;
                    world.func_195594_a((IParticleData)ParticleTypes.field_197620_m, entityItem.func_226277_ct_(), entityItem.func_226278_cu_() + 0.2, entityItem.func_226281_cx_(), vx, vy, vz);
                }
                if (!((TFPortalBlock)TFBlocks.twilight_portal.get()).tryToCreatePortal(world, pos, entityItem, player)) continue;
                TFAdvancements.MADE_TF_PORTAL.trigger((ServerPlayerEntity)player);
                return;
            }
        }
    }
}

