/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public abstract class RandomizedTemplateProcessor
extends StructureProcessor {
    protected final float integrity;

    public RandomizedTemplateProcessor(float integrity) {
        this.integrity = integrity;
    }

    protected boolean shouldPlaceBlock(Random random) {
        return this.integrity >= 1.0f || random.nextFloat() > this.integrity;
    }

    protected Block randomBlock(Random random, Block ... blocks) {
        return blocks[random.nextInt(blocks.length)];
    }

    protected static <T extends Comparable<T>> BlockState translateState(BlockState stateIn, Block blockOut, Property<T> property) {
        return (BlockState)blockOut.func_176223_P().func_206870_a(property, stateIn.func_177229_b(property));
    }

    protected static BlockState translateState(BlockState stateIn, Block blockOut, Property<?> ... properties) {
        BlockState stateOut = blockOut.func_176223_P();
        for (Property<?> property : properties) {
            stateOut = RandomizedTemplateProcessor.copyValue(stateIn, stateOut, property);
        }
        return stateOut;
    }

    private static <T extends Comparable<T>> BlockState copyValue(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.func_206870_a(property, from.func_177229_b(property));
    }
}

