/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;

public class UpdateShieldPacket {
    private final int entityID;
    private final int temporaryShields;
    private final int permanentShields;

    public UpdateShieldPacket(int id, IShieldCapability cap) {
        this.entityID = id;
        this.temporaryShields = cap.temporaryShieldsLeft();
        this.permanentShields = cap.permanentShieldsLeft();
    }

    public UpdateShieldPacket(Entity entity, IShieldCapability cap) {
        this(entity.func_145782_y(), cap);
    }

    public UpdateShieldPacket(PacketBuffer buf) {
        this.entityID = buf.readInt();
        this.temporaryShields = buf.readInt();
        this.permanentShields = buf.readInt();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.temporaryShields);
        buf.writeInt(this.permanentShields);
    }

    public static class Handler {
        public static boolean onMessage(final UpdateShieldPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
                    if (entity instanceof LivingEntity) {
                        entity.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
                            cap.setShields(message.temporaryShields, true);
                            cap.setShields(message.permanentShields, false);
                        });
                    }
                }
            });
            return true;
        }
    }
}

