/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.entity.CubeOfAnnihilationEntity;
import twilightforest.entity.TFEntities;

public class CubeOfAnnihilationItem
extends Item {
    private static final String THROWN_UUID_KEY = "cubeEntity";

    protected CubeOfAnnihilationItem(Item.Properties props) {
        super(props);
    }

    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean isSelected) {
        if (!world.field_72995_K && CubeOfAnnihilationItem.getThrownUuid(stack) != null && CubeOfAnnihilationItem.getThrownEntity(world, stack) == null) {
            stack.func_77978_p().func_82580_o(THROWN_UUID_KEY);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CubeOfAnnihilationItem.getThrownUuid(stack) != null) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            CubeOfAnnihilationEntity launchedCube = new CubeOfAnnihilationEntity(TFEntities.cube_of_annihilation, world, (LivingEntity)player);
            world.func_217376_c((Entity)launchedCube);
            CubeOfAnnihilationItem.setThrownEntity(stack, launchedCube);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nullable
    protected static UUID getThrownUuid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(THROWN_UUID_KEY)) {
            return stack.func_77978_p().func_186857_a(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private static CubeOfAnnihilationEntity getThrownEntity(World world, ItemStack stack) {
        Entity e;
        UUID id;
        if (world instanceof ServerWorld && (id = CubeOfAnnihilationItem.getThrownUuid(stack)) != null && (e = ((ServerWorld)world).func_217461_a(id)) instanceof CubeOfAnnihilationEntity) {
            return (CubeOfAnnihilationEntity)e;
        }
        return null;
    }

    private static void setThrownEntity(ItemStack stack, CubeOfAnnihilationEntity cube) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_186854_a(THROWN_UUID_KEY, cube.func_110124_au());
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

