/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.Locale;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public enum NagastoneVariant implements IStringSerializable
{
    NORTH_DOWN,
    SOUTH_DOWN,
    WEST_DOWN,
    EAST_DOWN,
    NORTH_UP,
    SOUTH_UP,
    EAST_UP,
    WEST_UP,
    AXIS_X,
    AXIS_Y,
    AXIS_Z,
    SOLID;


    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static NagastoneVariant getVariantFromAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return AXIS_X;
            }
            case Y: {
                return AXIS_Y;
            }
            case Z: {
                return AXIS_Z;
            }
        }
        return SOLID;
    }

    public static NagastoneVariant getVariantFromDoubleFacing(Direction facing1, Direction facing2) {
        Direction otherFace;
        if (facing1.func_176740_k() == facing2.func_176740_k()) {
            return NagastoneVariant.getVariantFromAxis(facing1.func_176740_k());
        }
        if (facing1.func_176740_k() != Direction.Axis.Y && facing2.func_176740_k() != Direction.Axis.Y) {
            return SOLID;
        }
        Direction facingYAxis = facing1.func_176740_k() == Direction.Axis.Y ? facing1 : facing2;
        Direction direction = otherFace = facing1.func_176740_k() != Direction.Axis.Y ? facing1 : facing2;
        if (facingYAxis == Direction.UP) {
            switch (otherFace) {
                case NORTH: {
                    return NORTH_UP;
                }
                case SOUTH: {
                    return SOUTH_UP;
                }
                case WEST: {
                    return WEST_UP;
                }
                case EAST: {
                    return EAST_UP;
                }
            }
            return SOLID;
        }
        switch (otherFace) {
            case NORTH: {
                return NORTH_DOWN;
            }
            case SOUTH: {
                return SOUTH_DOWN;
            }
            case WEST: {
                return WEST_DOWN;
            }
            case EAST: {
                return EAST_DOWN;
            }
        }
        return SOLID;
    }
}

