/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import twilightforest.TFSounds;
import twilightforest.enums.MagicWoodVariant;
import twilightforest.item.OreMagnetItem;
import twilightforest.network.ChangeBiomePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;
import twilightforest.worldgen.biomes.BiomeKeys;

public class SpecialMagicLogBlock
extends RotatedPillarBlock {
    private final MagicWoodVariant magicWoodVariant;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    protected SpecialMagicLogBlock(AbstractBlock.Properties props, MagicWoodVariant variant) {
        super(props.func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a).func_235838_a_(state -> 15));
        this.magicWoodVariant = variant;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        super.func_206840_a(container);
        container.func_206894_a(new Property[]{ACTIVE});
    }

    public int tickRate() {
        return 20;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate());
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.field_72995_K || !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            return;
        }
        switch (this.magicWoodVariant) {
            case TIME: {
                world.func_184133_a(null, pos, TFSounds.TIME_CORE, SoundCategory.BLOCKS, 0.1f, 0.5f);
                this.doTreeOfTimeEffect((World)world, pos, rand);
                break;
            }
            case TRANS: {
                world.func_184133_a(null, pos, TFSounds.TRANSFORMATION_CORE, SoundCategory.BLOCKS, 0.1f, rand.nextFloat() * 2.0f);
                this.doTreeOfTransformationEffect((World)world, pos, rand);
                break;
            }
            case MINE: {
                this.doMinersTreeEffect((World)world, pos, rand);
                break;
            }
            case SORT: {
                this.doSortingTreeEffect((World)world, pos, rand);
            }
        }
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate());
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate());
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void doTreeOfTimeEffect(World world, BlockPos pos, Random rand) {
        int numticks = 24 * this.tickRate();
        for (int i = 0; i < numticks; ++i) {
            TileEntity te;
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, 16);
            BlockState state = world.func_180495_p(dPos);
            if (state.func_204519_t()) {
                state.func_227034_b_((ServerWorld)world, dPos, rand);
            }
            if (!((te = world.func_175625_s(dPos)) instanceof ITickableTileEntity) || te.func_145837_r()) continue;
            ((ITickableTileEntity)te).func_73660_a();
        }
    }

    private void doTreeOfTransformationEffect(World world, BlockPos pos, Random rand) {
        int WIDTH_BITS = (int)Math.round(Math.log(16.0) / Math.log(2.0)) - 2;
        int HEIGHT_BITS = (int)Math.round(Math.log(256.0) / Math.log(2.0)) - 2;
        int HORIZONTAL_MASK = (1 << WIDTH_BITS) - 1;
        int VERTICAL_MASK = (1 << HEIGHT_BITS) - 1;
        Biome targetBiome = (Biome)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(BiomeKeys.ENCHANTED_FOREST);
        for (int i = 0; i < 16; ++i) {
            Biome biomeAt;
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, 16, 0, 16);
            if (dPos.func_177951_i((Vector3i)pos) > 256.0 || (biomeAt = world.func_226691_t_(dPos)) == targetBiome) continue;
            Chunk chunkAt = world.func_212866_a_(dPos.func_177958_n() >> 4, dPos.func_177952_p() >> 4);
            int x = dPos.func_177958_n() >> 2 & HORIZONTAL_MASK;
            int z = dPos.func_177952_p() >> 2 & HORIZONTAL_MASK;
            if (chunkAt.func_225549_i_().field_227054_f_[z << WIDTH_BITS | x] == targetBiome) continue;
            for (int dy = 0; dy < 255; dy += 4) {
                int y = MathHelper.func_76125_a((int)(dy >> 2), (int)0, (int)VERTICAL_MASK);
                chunkAt.func_225549_i_().field_227054_f_[y << WIDTH_BITS + WIDTH_BITS | z << WIDTH_BITS | x] = targetBiome;
            }
            if (!(world instanceof ServerWorld)) break;
            this.sendChangedBiome(chunkAt, dPos, targetBiome);
            break;
        }
    }

    private void sendChangedBiome(Chunk chunk, BlockPos pos, Biome biome) {
        ChangeBiomePacket message = new ChangeBiomePacket(pos, biome.getRegistryName());
        TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)message);
    }

    private void doMinersTreeEffect(World world, BlockPos pos, Random rand) {
        BlockPos dPos = WorldUtil.randomOffset(rand, pos, 32);
        int moved = OreMagnetItem.doMagnet(world, pos, dPos);
        if (moved > 0) {
            world.func_184133_a(null, pos, TFSounds.MAGNET_GRAB, SoundCategory.BLOCKS, 0.1f, 1.0f);
        }
    }

    private void doSortingTreeEffect(World world, BlockPos pos, Random rand) {
        ArrayList<IInventory> chests = new ArrayList<IInventory>();
        int itemCount = 0;
        for (BlockPos iterPos : WorldUtil.getAllAround(pos, 16)) {
            TileEntity te;
            IInventory chestInventory = null;
            IInventory teInventory = null;
            Block block = world.func_180495_p(iterPos).func_177230_c();
            if (block instanceof ChestBlock) {
                chestInventory = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)block.func_176223_P(), (World)world, (BlockPos)iterPos, (boolean)true);
            }
            if ((te = world.func_175625_s(iterPos)) instanceof IInventory && !te.func_145837_r()) {
                teInventory = (IInventory)te;
            }
            if (chestInventory == null || teInventory == null || this.checkIfChestsContains(chests, teInventory)) continue;
            boolean empty = true;
            for (int i = 0; i < chestInventory.func_70302_i_(); ++i) {
                if (chestInventory.func_70301_a(i).func_190926_b()) continue;
                empty = false;
                ++itemCount;
            }
            if (empty) continue;
            chests.add(chestInventory);
        }
        ItemStack beingSorted = ItemStack.field_190927_a;
        int sortedChestNum = -1;
        int sortedSlotNum = -1;
        if (itemCount == 0) {
            return;
        }
        int itemNumber = rand.nextInt(itemCount);
        int currentNumber = 0;
        for (int i = 0; i < chests.size(); ++i) {
            IInventory chest = (IInventory)chests.get(i);
            for (int slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                ItemStack currentItem = chest.func_70301_a(slotNum);
                if (currentItem.func_190926_b() || currentNumber++ != itemNumber) continue;
                beingSorted = currentItem;
                sortedChestNum = i;
                sortedSlotNum = slotNum;
            }
        }
        if (beingSorted.func_190926_b()) {
            return;
        }
        int matchChestNum = -1;
        int matchCount = 0;
        for (int chestNum = 0; chestNum < chests.size(); ++chestNum) {
            IInventory chest = (IInventory)chests.get(chestNum);
            int currentChestMatches = 0;
            for (int slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                ItemStack currentItem = chest.func_70301_a(slotNum);
                if (currentItem.func_190926_b() || !this.isSortingMatch(beingSorted, currentItem)) continue;
                currentChestMatches += currentItem.func_190916_E();
            }
            if (currentChestMatches <= matchCount) continue;
            matchCount = currentChestMatches;
            matchChestNum = chestNum;
        }
        if (matchChestNum >= 0 && matchChestNum != sortedChestNum) {
            IInventory moveChest = (IInventory)chests.get(matchChestNum);
            IInventory oldChest = (IInventory)chests.get(sortedChestNum);
            int moveSlot = this.getEmptySlotIn(moveChest);
            if (moveSlot >= 0) {
                oldChest.func_70299_a(sortedSlotNum, ItemStack.field_190927_a);
                moveChest.func_70299_a(moveSlot, beingSorted);
            }
        }
        if (beingSorted.func_190916_E() < beingSorted.func_77976_d()) {
            for (IInventory chest : chests) {
                for (int slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                    ItemStack currentItem = chest.func_70301_a(slotNum);
                    if (currentItem.func_190926_b() || currentItem == beingSorted || !beingSorted.func_77969_a(currentItem) || currentItem.func_77978_p() == null || beingSorted.func_77978_p() == null || !beingSorted.func_77978_p().equals((Object)currentItem.func_77978_p()) || currentItem.func_190916_E() > beingSorted.func_77976_d() - beingSorted.func_190916_E()) continue;
                    chest.func_70299_a(slotNum, ItemStack.field_190927_a);
                    beingSorted.func_190917_f(currentItem.func_190916_E());
                    currentItem.func_190920_e(0);
                }
            }
        }
    }

    private boolean isSortingMatch(ItemStack beingSorted, ItemStack currentItem) {
        return beingSorted.func_77973_b().func_77640_w() == currentItem.func_77973_b().func_77640_w();
    }

    private boolean checkIfChestsContains(List<IInventory> chests, IInventory testChest) {
        for (IInventory chest : chests) {
            if (chest == testChest) {
                return true;
            }
            if (!(chest instanceof DoubleSidedInventory) || !((DoubleSidedInventory)chest).func_90010_a(testChest)) continue;
            return true;
        }
        return false;
    }

    private int getEmptySlotIn(IInventory chest) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (!chest.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }
}

