/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.castcrafter.travel_anchors.TeleportHandler;
import de.castcrafter.travel_anchors.TravelAnchors;
import de.castcrafter.travel_anchors.block.TileTravelAnchor;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import org.apache.commons.lang3.tuple.Pair;

public class RenderTravelAnchor
extends TileEntityRenderer<TileTravelAnchor> {
    public static final ResourceLocation ANCHOR_MODEL = new ResourceLocation(TravelAnchors.getInstance().modid, "block/travel_anchor");
    private static IBakedModel ANCHOR_MODEL_BAKED = null;

    public RenderTravelAnchor(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileTravelAnchor tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile.getMimic() == null || tile.getMimic().func_177230_c() == tile.func_195044_w().func_177230_c() || tile.getMimic().func_196958_f()) {
            IVertexBuilder vertexBuffer = buffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)tile.func_195044_w(), (boolean)false));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(matrixStack.func_227866_c_(), vertexBuffer, tile.func_195044_w(), ANCHOR_MODEL_BAKED, 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.field_229196_a_);
        } else {
            Minecraft.func_71410_x().func_175602_ab().renderBlock(tile.getMimic(), matrixStack, buffer, combinedLight, OverlayTexture.field_229196_a_, tile.getModelData());
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.func_225608_bj_() && (TeleportHandler.canPlayerTeleport((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Hand.MAIN_HAND) || TeleportHandler.canPlayerTeleport((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Hand.OFF_HAND))) {
            Pair<BlockPos, String> anchor = TeleportHandler.getAnchorToTeleport((World)Minecraft.func_71410_x().field_71441_e, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_185334_h().func_177977_b());
            BlockPos pos = tile.func_174877_v();
            double doubleScale = Math.sqrt(0.0035 * Minecraft.func_71410_x().field_71439_g.func_213303_ch().func_72438_d(new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5)));
            if (doubleScale < (double)0.1f) {
                doubleScale = 0.1f;
            }
            float scale = (float)(doubleScale *= Math.sin(Math.toRadians(Minecraft.func_71410_x().field_71474_y.field_74334_X / 4.0)));
            StringTextComponent tc = new StringTextComponent(tile.getName());
            int color = 0xFFFFFF;
            if (anchor != null && ((BlockPos)anchor.getLeft()).equals((Object)tile.func_174877_v())) {
                doubleScale = (double)1.3f * doubleScale;
                tc = tc.func_240699_a_(TextFormatting.GOLD);
                color = TextFormatting.GOLD.func_211163_e() == null ? 0xFFFFFF : TextFormatting.GOLD.func_211163_e();
            }
            matrixStack.func_227860_a_();
            Minecraft.func_71410_x().field_71466_p.getClass();
            matrixStack.func_227861_a_(0.5, 1.05 + doubleScale * 9.0, 0.5);
            matrixStack.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            matrixStack.func_227862_a_(-scale, -scale, scale);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            float textOpacitySetting = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.5f);
            int alpha = (int)(textOpacitySetting * 255.0f) << 24;
            float halfWidth = -Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)tc) / 2;
            Minecraft.func_71410_x().field_71466_p.func_243247_a((ITextComponent)tc, halfWidth, 0.0f, color, false, matrix4f, buffer, true, alpha, LightTexture.func_228451_a_((int)15, (int)15));
            Minecraft.func_71410_x().field_71466_p.func_243247_a((ITextComponent)tc, halfWidth, 0.0f, color, false, matrix4f, buffer, false, 0, LightTexture.func_228451_a_((int)15, (int)15));
            matrixStack.func_227865_b_();
        }
    }

    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)ANCHOR_MODEL);
    }

    public static void bakeModels(ModelBakeEvent event) {
        ANCHOR_MODEL_BAKED = (IBakedModel)event.getModelRegistry().get(ANCHOR_MODEL);
    }
}

