/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors;

import de.castcrafter.travel_anchors.TravelAnchors;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.commons.lang3.tuple.Pair;

public class TravelAnchorList
extends WorldSavedData {
    private static final TravelAnchorList clientInstance = new TravelAnchorList();
    public final HashMap<BlockPos, String> anchors = new HashMap();

    public static TravelAnchorList get(World world) {
        if (!world.field_72995_K) {
            DimensionSavedDataManager storage = ((ServerWorld)world).func_217481_x();
            return (TravelAnchorList)storage.func_215752_a(TravelAnchorList::new, TravelAnchors.getInstance().modid);
        }
        return clientInstance;
    }

    public TravelAnchorList() {
        super(TravelAnchors.getInstance().modid);
    }

    public TravelAnchorList(String name) {
        super(name);
    }

    public void func_76184_a(@Nonnull CompoundNBT nbt) {
        this.anchors.clear();
        if (nbt.func_150297_b("anchors", 9)) {
            ListNBT list = nbt.func_150295_c("anchors", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT entryNBT = list.func_150305_b(i);
                if (!entryNBT.func_74764_b("x") || !entryNBT.func_74764_b("y") || !entryNBT.func_74764_b("z") || !entryNBT.func_74764_b("name")) continue;
                BlockPos pos = new BlockPos(entryNBT.func_74762_e("x"), entryNBT.func_74762_e("y"), entryNBT.func_74762_e("z")).func_185334_h();
                String name = entryNBT.func_74779_i("name");
                if (name.isEmpty()) continue;
                this.anchors.put(pos, entryNBT.func_74779_i("name"));
            }
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (Map.Entry<BlockPos, String> entry : this.anchors.entrySet()) {
            CompoundNBT entryNBT = new CompoundNBT();
            entryNBT.func_74768_a("x", entry.getKey().func_177958_n());
            entryNBT.func_74768_a("y", entry.getKey().func_177956_o());
            entryNBT.func_74768_a("z", entry.getKey().func_177952_p());
            entryNBT.func_74778_a("name", entry.getValue());
            list.add((Object)entryNBT);
        }
        nbt.func_218657_a("anchors", (INBT)list);
        return nbt;
    }

    public void setAnchor(World world, BlockPos pos, @Nullable String name) {
        if (!world.field_72995_K) {
            boolean needsUpdate = false;
            BlockPos immutablePos = pos.func_185334_h();
            if (name == null || name.trim().isEmpty()) {
                if (this.anchors.containsKey(immutablePos)) {
                    this.anchors.remove(immutablePos);
                    needsUpdate = true;
                }
            } else {
                String oldName = this.anchors.getOrDefault(immutablePos, null);
                if (oldName == null || !oldName.equals(name)) {
                    this.anchors.put(pos.func_185334_h(), name);
                    needsUpdate = true;
                }
            }
            this.func_76185_a();
            if (needsUpdate) {
                TravelAnchors.getNetwork().updateTravelAnchorList(world, this);
            }
        }
    }

    public String getAnchor(BlockPos pos) {
        return this.anchors.getOrDefault(pos.func_185334_h(), null);
    }

    public Stream<Pair<BlockPos, String>> getAnchorsAround(Vector3d pos, double maxDistanceSq) {
        return this.anchors.entrySet().stream().filter(entry -> ((BlockPos)entry.getKey()).func_218140_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, true) < maxDistanceSq).map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }
}

