/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors.block;

import de.castcrafter.travel_anchors.TravelAnchorList;
import de.castcrafter.travel_anchors.block.ContainerTravelAnchor;
import de.castcrafter.travel_anchors.block.TileTravelAnchor;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockGUI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTravelAnchor
extends BlockGUI<TileTravelAnchor, ContainerTravelAnchor> {
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);

    public BlockTravelAnchor(ModX mod, Class<TileTravelAnchor> teClass, ContainerType<ContainerTravelAnchor> container, AbstractBlock.Properties properties) {
        super(mod, teClass, container, properties);
    }

    public BlockTravelAnchor(ModX mod, Class<TileTravelAnchor> teClass, ContainerType<ContainerTravelAnchor> container, AbstractBlock.Properties properties, Item.Properties itemProperties) {
        super(mod, teClass, container, properties, itemProperties);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState mimic;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTravelAnchor && (mimic = ((TileTravelAnchor)tile).getMimic()) != null) {
            return mimic.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, IBlockReader reader, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        BlockState mimic;
        TileEntity tile = reader.func_175625_s(pos);
        if (tile instanceof TileTravelAnchor && (mimic = ((TileTravelAnchor)tile).getMimic()) != null) {
            return mimic.func_215700_a(reader, pos, context);
        }
        return VoxelShapes.func_197868_b();
    }

    @Nonnull
    public VoxelShape func_196247_c(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        BlockState mimic;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTravelAnchor && (mimic = ((TileTravelAnchor)tile).getMimic()) != null) {
            return mimic.func_196951_e(world, pos);
        }
        return SHAPE;
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, @Nonnull ITooltipFlag flags) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.travel_anchors.travel_anchor_block"));
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            ItemStack item = player.func_184586_b(Hand.OFF_HAND);
            if (!item.func_190926_b() && item.func_77973_b() instanceof BlockItem && player.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileTravelAnchor) {
                    BlockState mimicState = ((BlockItem)item.func_77973_b()).func_179223_d().func_196258_a(new BlockItemUseContext(player, Hand.OFF_HAND, item, hit));
                    if (mimicState == null || mimicState.func_177230_c() == this) {
                        ((TileTravelAnchor)te).setMimic(null);
                    } else {
                        ((TileTravelAnchor)te).setMimic(mimicState);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            super.func_225533_a_(state, world, pos, player, hand, hit);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        TravelAnchorList.get(world).setAnchor(world, pos, null);
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

