/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors;

import de.castcrafter.travel_anchors.ModComponents;
import de.castcrafter.travel_anchors.ModEnchantments;
import de.castcrafter.travel_anchors.TravelAnchorList;
import de.castcrafter.travel_anchors.block.TileTravelAnchor;
import de.castcrafter.travel_anchors.config.ServerConfig;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class TeleportHandler {
    public static boolean anchorTeleport(World world, PlayerEntity player, @Nullable BlockPos except, @Nullable Hand hand) {
        Pair<BlockPos, String> anchor = TeleportHandler.getAnchorToTeleport(world, player, except);
        return TeleportHandler.teleportPlayer(player, anchor, hand);
    }

    public static Pair<BlockPos, String> getAnchorToTeleport(World world, PlayerEntity player, @Nullable BlockPos except) {
        if (!player.func_225608_bj_()) {
            double maxDistance = TeleportHandler.getMaxDistance(player);
            Vector3d positionVec = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            Optional<Pair> anchor = TravelAnchorList.get(world).getAnchorsAround(player.func_213303_ch(), Math.pow(maxDistance, 2.0)).filter(pair -> except == null || !except.equals(pair.getLeft())).min((p1, p2) -> {
                double angle1 = Math.abs(TeleportHandler.getAngleRadians(positionVec, (BlockPos)p1.getLeft(), player.field_70177_z, player.field_70125_A));
                double angle2 = Math.abs(TeleportHandler.getAngleRadians(positionVec, (BlockPos)p2.getLeft(), player.field_70177_z, player.field_70125_A));
                return Double.compare(angle1, angle2);
            }).filter(p -> Math.abs(TeleportHandler.getAngleRadians(positionVec, (BlockPos)p.getLeft(), player.field_70177_z, player.field_70125_A)) <= Math.toRadians((Double)ServerConfig.MAX_ANGLE.get())).filter(p -> TeleportHandler.canTeleportTo((IBlockReader)world, (BlockPos)p.getLeft()));
            return anchor.orElse(null);
        }
        return null;
    }

    public static boolean teleportPlayer(PlayerEntity player, @Nullable Pair<BlockPos, String> anchor, @Nullable Hand hand) {
        if (anchor != null) {
            if (!player.func_130014_f_().field_72995_K) {
                Vector3d teleportVec = TeleportHandler.checkTeleport(player, ((BlockPos)anchor.getLeft()).func_177984_a());
                if (teleportVec == null) {
                    return false;
                }
                player.func_70634_a(teleportVec.func_82615_a(), teleportVec.func_82617_b(), teleportVec.func_82616_c());
            }
            player.field_70143_R = 0.0f;
            if (hand != null) {
                player.func_226292_a_(hand, true);
            }
            player.func_213823_a(SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.ACTIONBAR, (ITextComponent)new TranslationTextComponent("travel_anchors.tp.success", new Object[]{anchor.getRight()}), 10, 60, 10));
            }
            return true;
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.ACTIONBAR, (ITextComponent)new TranslationTextComponent("travel_anchors.tp.fail"), 10, 60, 10));
        }
        return false;
    }

    public static boolean shortTeleport(World world, PlayerEntity player, Hand hand) {
        Vector3d targetVec = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vector3d lookVec = player.func_70040_Z();
        BlockPos target = null;
        for (double i = 7.0; i >= 2.0; i -= 0.5) {
            Vector3d v3d = targetVec.func_178787_e(lookVec.func_216372_d(i, i, i));
            target = new BlockPos((double)Math.round(v3d.field_72450_a), (double)Math.round(v3d.field_72448_b), (double)Math.round(v3d.field_72449_c));
            if (TeleportHandler.canTeleportTo((IBlockReader)world, target.func_177977_b())) break;
            target = null;
        }
        if (target != null) {
            if (!player.func_130014_f_().field_72995_K) {
                Vector3d teleportVec = TeleportHandler.checkTeleport(player, target);
                if (teleportVec == null) {
                    return false;
                }
                player.func_70634_a(teleportVec.func_82615_a(), teleportVec.func_82617_b(), teleportVec.func_82616_c());
            }
            player.field_70143_R = 0.0f;
            player.func_226292_a_(hand, true);
            player.func_213823_a(SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.ACTIONBAR, (ITextComponent)new TranslationTextComponent("travel_anchors.hop.fail"), 10, 60, 10));
        }
        return false;
    }

    public static boolean canTeleportTo(IBlockReader world, BlockPos target) {
        return !world.func_180495_p(target.func_185334_h().func_177981_b(1)).func_200132_m() && !world.func_180495_p(target.func_185334_h().func_177981_b(2)).func_200132_m() && target.func_177956_o() > 0;
    }

    public static boolean canPlayerTeleport(PlayerEntity player, Hand hand) {
        return TeleportHandler.canItemTeleport(player, hand) || TeleportHandler.canBlockTeleport(player);
    }

    public static boolean canBlockTeleport(PlayerEntity player) {
        return player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_185334_h().func_177977_b()).func_177230_c() == ModComponents.travelAnchor && !player.func_225608_bj_();
    }

    public static boolean canItemTeleport(PlayerEntity player, Hand hand) {
        return player.func_184586_b(hand).func_77973_b() == ModComponents.travelStaff || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.teleportation, (ItemStack)player.func_184586_b(hand)) >= 1;
    }

    private static double getAngleRadians(Vector3d positionVec, BlockPos anchor, float yaw, float pitch) {
        Vector3d blockVec = new Vector3d((double)anchor.func_177958_n() + 0.5 - positionVec.field_72450_a, (double)anchor.func_177956_o() + 1.0 - positionVec.field_72448_b, (double)anchor.func_177952_p() + 0.5 - positionVec.field_72449_c).func_72432_b();
        Vector3d lookVec = Vector3d.func_189986_a((float)pitch, (float)yaw).func_72432_b();
        return Math.acos(lookVec.func_72430_b(blockVec));
    }

    public static double getMaxDistance(PlayerEntity player) {
        int mainHandLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.range, (ItemStack)player.func_184586_b(Hand.MAIN_HAND));
        int offHandLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.range, (ItemStack)player.func_184586_b(Hand.OFF_HAND));
        int lvl = Math.max(mainHandLevel, offHandLevel);
        return (Double)ServerConfig.MAX_DISTANCE.get() * (1.0 + (double)lvl / 2.0);
    }

    public static boolean canElevate(PlayerEntity player) {
        return player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_185334_h().func_177977_b()).func_177230_c() == ModComponents.travelAnchor;
    }

    public static boolean elevateUp(PlayerEntity player) {
        BlockPos target;
        String name;
        if (!TeleportHandler.canElevate(player)) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockPos.Mutable searchPos = player.func_233580_cy_().func_185334_h().func_239590_i_();
        while (!(World.func_189509_E((BlockPos)searchPos) || world.func_180495_p((BlockPos)searchPos).func_177230_c() == ModComponents.travelAnchor && TeleportHandler.canTeleportTo((IBlockReader)world, (BlockPos)searchPos))) {
            searchPos.func_189536_c(Direction.UP);
        }
        BlockState state = world.func_180495_p((BlockPos)searchPos);
        Pair anchor = null;
        if (state.func_177230_c() == ModComponents.travelAnchor && TeleportHandler.canTeleportTo((IBlockReader)world, (BlockPos)searchPos) && !(name = ((TileTravelAnchor)ModComponents.travelAnchor.getTile(world, target = searchPos.func_185334_h())).getName()).isEmpty()) {
            anchor = Pair.of((Object)target, (Object)name);
        }
        return TeleportHandler.teleportPlayer(player, anchor, null);
    }

    public static boolean elevateDown(PlayerEntity player) {
        BlockPos target;
        String name;
        if (!TeleportHandler.canElevate(player)) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockPos.Mutable searchPos = player.func_233580_cy_().func_185334_h().func_177979_c(2).func_239590_i_();
        while (!(World.func_189509_E((BlockPos)searchPos) || world.func_180495_p((BlockPos)searchPos).func_177230_c() == ModComponents.travelAnchor && TeleportHandler.canTeleportTo((IBlockReader)world, (BlockPos)searchPos))) {
            searchPos.func_189536_c(Direction.DOWN);
        }
        BlockState state = world.func_180495_p((BlockPos)searchPos);
        Pair anchor = null;
        if (state.func_177230_c() == ModComponents.travelAnchor && TeleportHandler.canTeleportTo((IBlockReader)world, (BlockPos)searchPos) && !(name = ((TileTravelAnchor)ModComponents.travelAnchor.getTile(world, target = searchPos.func_185334_h())).getName()).isEmpty()) {
            anchor = Pair.of((Object)target, (Object)name);
        }
        return TeleportHandler.teleportPlayer(player, anchor, null);
    }

    @Nullable
    private static Vector3d checkTeleport(PlayerEntity player, BlockPos target) {
        EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)player, (double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        return new Vector3d(event.getTargetX(), event.getTargetY(), event.getTargetZ());
    }
}

