/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleItemWhitelist;
import com.supermartijn642.trashcans.packet.PacketToggleLiquidWhitelist;
import com.supermartijn642.trashcans.screen.ArrowButton;
import com.supermartijn642.trashcans.screen.CheckBox;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanContainer;
import com.supermartijn642.trashcans.screen.WhitelistButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class UltimateTrashCanScreen
extends TrashCanScreen<UltimateTrashCanContainer> {
    private WhitelistButton itemWhitelistButton;
    private WhitelistButton liquidWhitelistButton;
    private CheckBox checkBox;
    private ArrowButton leftArrow;
    private ArrowButton rightArrow;
    private boolean shift;
    private boolean control;

    public UltimateTrashCanScreen(UltimateTrashCanContainer container) {
        super(container, "trashcans.gui.ultimate_trash_can.title");
    }

    protected void addWidgets(TrashCanTile tile) {
        this.itemWhitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, this.sizeY() - 185, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketToggleItemWhitelist(((UltimateTrashCanContainer)this.field_147002_h).getTilePos()))));
        this.itemWhitelistButton.update(tile.itemFilterWhitelist);
        this.liquidWhitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, this.sizeY() - 155, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketToggleLiquidWhitelist(((UltimateTrashCanContainer)this.field_147002_h).getTilePos()))));
        this.liquidWhitelistButton.update(tile.liquidFilterWhitelist);
        this.checkBox = (CheckBox)this.addWidget((Widget)new CheckBox(21, 127, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketToggleEnergyLimit(((UltimateTrashCanContainer)this.field_147002_h).getTilePos()))));
        this.checkBox.update(tile.useEnergyLimit);
        this.leftArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(49, 127, true, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketChangeEnergyLimit(((UltimateTrashCanContainer)this.field_147002_h).getTilePos(), this.shift ? (this.control ? -100000 : -100) : (this.control ? -10000 : -1000)))));
        this.leftArrow.active = tile.useEnergyLimit;
        this.rightArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(170, 127, false, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketChangeEnergyLimit(((UltimateTrashCanContainer)this.field_147002_h).getTilePos(), this.shift ? (this.control ? 100000 : 100) : (this.control ? 10000 : 1000)))));
        this.rightArrow.active = tile.useEnergyLimit;
    }

    protected void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY, TrashCanTile tile) {
        if (this.leftArrow.isHovered() && this.leftArrow.active) {
            this.renderToolTip(matrixStack, false, "" + (this.shift ? (this.control ? -100000 : -100) : (this.control ? -10000 : -1000)), mouseX, mouseY);
        }
        if (this.rightArrow.isHovered() && this.rightArrow.active) {
            this.renderToolTip(matrixStack, false, "+" + (this.shift ? (this.control ? 100000 : 100) : (this.control ? 10000 : 1000)), mouseX, mouseY);
        }
    }

    protected void tick(TrashCanTile tile) {
        this.itemWhitelistButton.update(tile.itemFilterWhitelist);
        this.liquidWhitelistButton.update(tile.liquidFilterWhitelist);
        this.checkBox.update(tile.useEnergyLimit);
        this.leftArrow.active = tile.useEnergyLimit;
        this.rightArrow.active = tile.useEnergyLimit;
    }

    @Override
    protected String getBackground() {
        return "ultimate_screen.png";
    }

    @Override
    protected void drawText(MatrixStack matrixStack, TrashCanTile tile) {
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("trashcans.gui.ultimate_trash_can.item_filter"), (float)8.0f, (float)53.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("trashcans.gui.ultimate_trash_can.liquid_filter"), (float)8.0f, (float)83.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("trashcans.gui.ultimate_trash_can.energy_limit"), (float)8.0f, (float)113.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"trashcans.gui.energy_trash_can.value", (Object[])new Object[0]).replace("$number$", "" + tile.energyLimit)), (float)114.0f, (float)132.0f);
    }

    public boolean keyPressed(int keyCode) {
        if (keyCode == 340) {
            this.shift = true;
        } else if (keyCode == 341) {
            this.control = true;
        }
        return super.keyPressed(keyCode);
    }

    public boolean keyReleased(int keyCode) {
        if (keyCode == 340) {
            this.shift = false;
        } else if (keyCode == 341) {
            this.control = false;
        }
        return super.keyReleased(keyCode);
    }
}

