/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.jei;

import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.screen.ItemTrashCanScreen;
import com.supermartijn642.trashcans.screen.LiquidTrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanScreen;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class GhostIngredientHandler
implements IGhostIngredientHandler<TrashCanScreen<?>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(final TrashCanScreen<?> screen, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Slot slot : ((TrashCanContainer)screen.func_212873_a_()).field_75151_b) {
            boolean isFluidFilterSlot;
            final Rectangle2d bounds = new Rectangle2d(screen.getGuiLeft() + slot.field_75223_e, screen.getGuiTop() + slot.field_75221_f, 17, 17);
            boolean isItemFilterSlot = screen instanceof ItemTrashCanScreen && slot.field_75222_d >= 1 && slot.field_75222_d <= 9 || screen instanceof UltimateTrashCanScreen && slot.field_75222_d >= 3 && slot.field_75222_d <= 11;
            boolean bl = isFluidFilterSlot = screen instanceof LiquidTrashCanScreen && slot.field_75222_d >= 1 && slot.field_75222_d <= 9 || screen instanceof UltimateTrashCanScreen && slot.field_75222_d >= 12 && slot.field_75222_d <= 20;
            if (isItemFilterSlot && ingredient instanceof ItemStack) {
                final int filterSlotNum = screen instanceof ItemTrashCanScreen ? slot.field_75222_d - 1 : slot.field_75222_d - 3;
                targets.add(new IGhostIngredientHandler.Target<I>(){

                    public Rectangle2d getArea() {
                        return bounds;
                    }

                    public void accept(I ingredient) {
                        TrashCanTile tile = ((TrashCanContainer)screen.func_212873_a_()).getObjectOrClose();
                        if (tile != null) {
                            tile.itemFilter.set(filterSlotNum, (ItemStack)ingredient);
                            TrashCans.CHANNEL.sendToServer((Object)new PacketChangeItemFilter(tile.func_174877_v(), filterSlotNum, (ItemStack)ingredient));
                        }
                    }
                });
                continue;
            }
            if (!isFluidFilterSlot) continue;
            ItemStack repitem = ItemStack.field_190927_a;
            if (ingredient instanceof ItemStack && this.isValidFluidItem((ItemStack)ingredient)) {
                repitem = (ItemStack)ingredient;
            } else if (ingredient instanceof FluidStack) {
                repitem = new ItemStack((IItemProvider)((FluidStack)ingredient).getFluid().func_204524_b());
            } else if (Compatibility.MEKANISM.isGasStack(ingredient)) {
                repitem = Compatibility.MEKANISM.getChemicalTankForGasStack(ingredient);
            }
            if (repitem.func_190926_b()) continue;
            final ItemStack finalrepitem = repitem;
            final int filterSlotNum = screen instanceof LiquidTrashCanScreen ? slot.field_75222_d - 1 : slot.field_75222_d - 12;
            targets.add(new IGhostIngredientHandler.Target<I>(){

                public Rectangle2d getArea() {
                    return bounds;
                }

                public void accept(I ingredient) {
                    TrashCanTile tile;
                    ItemFilter filter = LiquidTrashCanFilters.createFilter(finalrepitem);
                    if (filter != null && (tile = ((TrashCanContainer)screen.func_212873_a_()).getObjectOrClose()) != null) {
                        tile.liquidFilter.set(filterSlotNum, filter);
                        TrashCans.CHANNEL.sendToServer((Object)new PacketChangeLiquidFilter(tile.func_174877_v(), filterSlotNum, filter));
                    }
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }

    private boolean isValidFluidItem(ItemStack stack) {
        if (Compatibility.MEKANISM.doesItemHaveGasStored(stack)) {
            return true;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        return fluidHandler != null && fluidHandler.getTanks() == 1 && !fluidHandler.getFluidInTank(0).isEmpty();
    }
}

