/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.tile;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.init.TranslocatorsModContent;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class TileCraftingGrid
extends TileEntity
implements ITickableTileEntity {
    public ItemStack[] items = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[9], (Object)ItemStack.field_190927_a);
    public ItemStack result = ItemStack.field_190927_a;
    public int rotation = 0;
    public int timeout = 400;

    public TileCraftingGrid() {
        super((TileEntityType)TranslocatorsModContent.tileCraftingGridType.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("items", (INBT)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        tag.func_74768_a("timeout", this.timeout);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (ListNBT)tag.func_150295_c("items", 10));
        this.timeout = tag.func_74762_e("timeout");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d()) {
            --this.timeout;
            if (this.timeout == 0) {
                this.dropItems();
                this.field_145850_b.func_217377_a(this.func_174877_v(), false);
            }
        }
    }

    public void dropItems() {
        Vector3 drop = Vector3.fromTileCenter((TileEntity)this);
        for (ItemStack item : this.items) {
            if (item.func_190926_b()) continue;
            ItemUtils.dropItem((ItemStack)item, (World)this.field_145850_b, (Vector3)drop);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        MCDataByteBuf packet = new MCDataByteBuf();
        this.writeToPacket((MCDataOutput)packet);
        return packet.toTilePacket(this.func_174877_v());
    }

    public CompoundNBT func_189517_E_() {
        MCDataByteBuf packet = new MCDataByteBuf();
        this.writeToPacket((MCDataOutput)packet);
        return packet.writeToNBT(super.func_189517_E_(), "data");
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readFromPacket((MCDataInput)MCDataByteBuf.fromTilePacket((SUpdateTileEntityPacket)pkt));
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.readFromPacket((MCDataInput)MCDataByteBuf.readFromNBT((CompoundNBT)tag, (String)"data"));
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeByte(this.rotation);
        for (ItemStack item : this.items) {
            packet.writeItemStack(item);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.rotation = packet.readUByte();
        for (int i = 0; i < 9; ++i) {
            this.items[i] = packet.readItemStack();
        }
        this.updateResult();
    }

    public void activate(int subHit, PlayerEntity player) {
        ItemStack held = player.field_71071_by.func_70448_g();
        if (held.func_190926_b()) {
            if (!this.items[subHit].func_190926_b()) {
                this.giveOrDropItem(this.items[subHit], player);
            }
            this.items[subHit] = ItemStack.field_190927_a;
        } else if (!InventoryUtils.areStacksIdentical((ItemStack)held, (ItemStack)this.items[subHit])) {
            ItemStack old = this.items[subHit];
            this.items[subHit] = ItemUtils.copyStack((ItemStack)held, (int)1);
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            if (!old.func_190926_b()) {
                this.giveOrDropItem(old, player);
            }
        }
        this.timeout = 2400;
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        this.func_70296_d();
    }

    private void updateResult() {
        CraftingInventory craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            Optional mresult = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftMatrix, this.field_145850_b);
            if (mresult.isPresent()) {
                this.result = ((ICraftingRecipe)mresult.get()).func_77572_b((IInventory)craftMatrix);
                return;
            }
            this.rotateItems(craftMatrix);
        }
        this.result = ItemStack.field_190927_a;
    }

    private void giveOrDropItem(ItemStack stack, PlayerEntity player) {
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71069_bz.func_75142_b();
        } else {
            ItemUtils.dropItem((ItemStack)stack, (World)this.field_145850_b, (Vector3)Vector3.fromTileCenter((TileEntity)this));
        }
    }

    public void craft(ServerPlayerEntity player) {
        CraftingInventory craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            ICraftingRecipe recipe;
            Optional mresult = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftMatrix, this.field_145850_b);
            if (mresult.isPresent() && ((recipe = (ICraftingRecipe)mresult.get()).func_192399_d() || !this.field_145850_b.func_82736_K().func_223586_b(GameRules.field_223618_u) || player.func_192037_E().func_193830_f((IRecipe)recipe))) {
                this.doCraft(recipe, recipe.func_77572_b((IInventory)craftMatrix), craftMatrix, (PlayerEntity)player);
                break;
            }
            this.rotateItems(craftMatrix);
        }
        player.func_184609_a(Hand.MAIN_HAND);
        this.dropItems();
        this.field_145850_b.func_217377_a(this.func_174877_v(), false);
    }

    private CraftingInventory getCraftMatrix() {
        CraftingInventory craftMatrix = new CraftingInventory(new Container(null, 0){

            public boolean func_75145_c(PlayerEntity player) {
                return true;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftMatrix.func_70299_a(i, this.items[i]);
        }
        return craftMatrix;
    }

    private void doCraft(ICraftingRecipe recipe, ItemStack mresult, CraftingInventory craftMatrix, PlayerEntity player) {
        int i;
        this.giveOrDropItem(mresult, player);
        mresult.func_77980_a(this.field_145850_b, player, mresult.func_190916_E());
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)mresult, (IInventory)craftMatrix);
        if (!recipe.func_192399_d()) {
            player.func_195065_a(Collections.singleton(recipe));
        }
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        NonNullList remaining = recipe.func_179532_b((IInventory)craftMatrix);
        ForgeHooks.setCraftingPlayer(null);
        for (i = 0; i < remaining.size(); ++i) {
            ItemStack invStack = craftMatrix.func_70301_a(i);
            ItemStack remStack = (ItemStack)remaining.get(i);
            if (!invStack.func_190926_b()) {
                craftMatrix.func_70298_a(i, 1);
                invStack = craftMatrix.func_70301_a(i);
            }
            if (remStack.func_190926_b()) continue;
            if (invStack.func_190926_b()) {
                craftMatrix.func_70299_a(i, remStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)invStack, (ItemStack)remStack) && ItemStack.func_77970_a((ItemStack)invStack, (ItemStack)remStack)) {
                remStack.func_190917_f(invStack.func_190916_E());
                craftMatrix.func_70299_a(i, remStack);
                continue;
            }
            this.giveOrDropItem(remStack, player);
        }
        for (i = 0; i < 9; ++i) {
            this.items[i] = craftMatrix.func_70301_a(i);
        }
    }

    private void rotateItems(CraftingInventory inv) {
        int i;
        int[] slots = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
        ItemStack[] arrangement = new ItemStack[9];
        arrangement[4] = inv.func_70301_a(4);
        for (i = 0; i < 8; ++i) {
            arrangement[slots[(i + 2) % 8]] = inv.func_70301_a(slots[i]);
        }
        for (i = 0; i < 9; ++i) {
            inv.func_70299_a(i, arrangement[i]);
        }
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
    }
}

