/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.client.render;

import codechicken.lib.render.CCRenderEventHandler;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.tile.TileCraftingGrid;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;

public class TileCraftingGridRenderer
extends TileEntityRenderer<TileCraftingGrid> {
    public TileCraftingGridRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileCraftingGrid tile, float partialTicks, MatrixStack mStack, IRenderTypeBuffer buffers, int packedLight, int packedOverlay) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        TextureAtlasSprite icon = TranslocatorTextures.CRAFTING_GRID;
        Matrix4 mat = new Matrix4(mStack);
        mat.translate(0.0, 0.001, 0.0);
        ccrs.bind(RenderType.func_228643_e_(), buffers, mat);
        ccrs.normal.set(0.0, 1.0, 0.0);
        ccrs.vert.set(1.0, 0.0, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        ccrs.writeVert();
        ccrs.vert.set(0.0, 0.0, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        ccrs.writeVert();
        ccrs.vert.set(0.0, 0.0, 1.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        ccrs.writeVert();
        ccrs.vert.set(1.0, 0.0, 1.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        ccrs.writeVert();
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.5, 0.0, 0.5);
        Transformation orient = Rotation.quarterRotations[tile.rotation];
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = tile.items[i];
            if (stack.func_190926_b()) continue;
            int row = i / 3;
            int col = i % 3;
            Vector3 pos = new Vector3((double)((col - 1) * 5) / 16.0, 0.1 + 0.01 * Math.sin((double)i * 1.7 + ClientUtils.getRenderTime() / 5.0), (double)((row - 1) * 5) / 16.0).apply(orient);
            mStack.func_227860_a_();
            mStack.func_227861_a_(pos.x, pos.y, pos.z);
            mStack.func_227862_a_(0.35f, 0.35f, 0.35f);
            itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, packedLight, packedOverlay, mStack, buffers);
            mStack.func_227865_b_();
        }
        if (!tile.result.func_190926_b()) {
            mStack.func_227860_a_();
            mStack.func_227861_a_(0.0, 0.6 + 0.02 * Math.sin(ClientUtils.getRenderTime() / 10.0), 0.0);
            mStack.func_227862_a_(0.8f, 0.8f, 0.8f);
            float spin = (float)(ClientUtils.getRenderTime() * 9.0 / Math.PI);
            float bob = (float)(Math.sin(((float)CCRenderEventHandler.renderTime + spin) / 20.0f) * (double)0.1f + (double)0.1f);
            mStack.func_227861_a_(0.0, (double)bob + 0.25, 0.0);
            mStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(((float)CCRenderEventHandler.renderTime + spin) / 30.0f));
            itemRenderer.func_229110_a_(tile.result, ItemCameraTransforms.TransformType.FIXED, packedLight, packedOverlay, mStack, buffers);
            mStack.func_227865_b_();
        }
        mStack.func_227865_b_();
    }
}

