/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.block;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.handler.ConfigHandler;
import codechicken.translocators.tile.TileCraftingGrid;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockCraftingGrid
extends Block {
    private static final IndexedVoxelShape BASE = new IndexedVoxelShape(new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.005, 1.0).shape(), (Object)0);
    private static final IndexedVoxelShape[][] BUTTONS = new IndexedVoxelShape[4][9];
    private static final VoxelShape[] SHAPES = new VoxelShape[4];

    public BlockCraftingGrid() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCraftingGrid();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        IndexedVoxelShape shape = BASE;
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof TileCraftingGrid) {
            TileCraftingGrid tile = (TileCraftingGrid)t;
            shape = SHAPES[tile.rotation];
        }
        return shape;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos beneath = pos.func_177977_b();
        return world.func_180495_p(beneath).func_224755_d((IBlockReader)world, beneath, Direction.UP);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        TileCraftingGrid tcraft = (TileCraftingGrid)((Object)builder.func_216019_b(LootParameters.field_216288_h));
        if (tcraft != null) {
            for (ItemStack item : tcraft.items) {
                if (item == null) continue;
                stacks.add(item.func_77946_l());
            }
        }
        return stacks;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.func_201670_d()) {
            return ActionResultType.PASS;
        }
        TileCraftingGrid tcraft = (TileCraftingGrid)world.func_175625_s(pos);
        if (hit != null) {
            if (hit.subHit > 0) {
                tcraft.activate(hit.subHit - 1, player);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean placeBlock(World world, PlayerEntity player, BlockPos pos, Direction side) {
        BlockRayTraceResult hit;
        BlockItemUseContext ctx;
        if (ConfigHandler.disableCraftingGrid || side != Direction.UP) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (!state.func_196953_a(ctx = new BlockItemUseContext(player, Hand.MAIN_HAND, ItemStack.field_190927_a, hit = RayTracer.retrace((PlayerEntity)player)))) {
            pos = pos.func_177984_a();
        }
        if (!world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP)) {
            return false;
        }
        player.func_184609_a(Hand.MAIN_HAND);
        if (!world.func_175656_a(pos, this.func_176223_P())) {
            return false;
        }
        this.func_180633_a(world, pos, this.func_176223_P(), (LivingEntity)player, null);
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        ((TileCraftingGrid)world.func_175625_s(pos)).onPlaced(placer);
    }

    static {
        for (int rot = 0; rot < 4; ++rot) {
            for (int b = 0; b < 9; ++b) {
                Cuboid6 box = new Cuboid6(0.0625, 0.0, 0.0625, 0.3125, 0.01, 0.3125).apply((Transformation)new Translation((double)(b % 3 * 5) / 16.0, 0.0, (double)(b / 3 * 5) / 16.0).with(Rotation.quarterRotations[rot].at(Vector3.CENTER)));
                BlockCraftingGrid.BUTTONS[rot][b] = new IndexedVoxelShape(box.shape(), (Object)(b + 1));
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add((Object)BASE);
            builder.add(BUTTONS[rot]);
            BlockCraftingGrid.SHAPES[rot] = new MultiIndexedVoxelShape((VoxelShape)BASE, builder.build());
        }
    }
}

