/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.client.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.CustomGradient;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.multipart.block.TileMultiPart;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.part.FluidTranslocatorPart;
import codechicken.translocators.part.ItemTranslocatorPart;
import codechicken.translocators.part.TranslocatorPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class RenderTranslocator {
    public static Vector3[] sidePos = new Vector3[]{new Vector3(0.5, 0.0, 0.5), new Vector3(0.5, 1.0, 0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.5, 1.0), new Vector3(0.0, 0.5, 0.5), new Vector3(1.0, 0.5, 0.5)};
    public static Vector3[] sideVec = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    private static final CCModel[] plates = new CCModel[6];
    private static final CCModel insert;
    private static final CustomGradient gradient;
    private static final RenderType ITEM_RENDER_TYPE;
    private static final RenderType particleType;

    public static void renderStatic(CCRenderState ccrs, TranslocatorPart p) {
        Vector3 trans = Vector3.CENTER;
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[p.getTType()][p.getIconIndex()]);
        ccrs.reset();
        ccrs.setBrightness((IBlockDisplayReader)p.world(), p.pos());
        plates[p.side].render(ccrs, new IVertexOperation[]{trans.translation(), i_trans});
    }

    public static void renderInsert(TranslocatorPart p, CCRenderState ccrs, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay, float delta) {
        Matrix4 mat = new Matrix4(mStack);
        double insertpos = MathHelper.interpolate((double)p.b_insertpos, (double)p.a_insertpos, (double)delta);
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[p.getTType()][p.getIconIndex()]);
        mat.translate(Vector3.CENTER);
        mat.apply(Rotation.sideRotations[p.side]);
        mat.translate(new Vector3(0.0, -0.5, 0.0));
        mat.scale(1.0, insertpos * 2.0 / 3.0 + 0.3333333333333333, 1.0);
        ccrs.reset();
        ccrs.bind(RenderType.func_228639_c_(), getter);
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        insert.render(ccrs, new IVertexOperation[]{mat, i_trans});
    }

    public static void renderItem(int type, MatrixStack mStack, ItemCameraTransforms.TransformType transformType, IRenderTypeBuffer buffers, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(ITEM_RENDER_TYPE, buffers);
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[type][0]);
        Vector3 v_trans = Vector3.CENTER.copy().add(0.0, 0.0, 0.5);
        if (transformType == ItemCameraTransforms.TransformType.GROUND) {
            v_trans.subtract(0.0, 0.5, 0.0);
        }
        Matrix4 mat = new Matrix4(mStack);
        Matrix4 i_matrix = mat.copy().translate(v_trans).apply(Rotation.sideRotations[2]).translate(new Vector3(0.0, -0.5, 0.0)).scale(new Vector3(1.0, 1.0, 1.0));
        mat.translate(v_trans);
        plates[2].render(ccrs, new IVertexOperation[]{mat, i_trans});
        insert.render(ccrs, new IVertexOperation[]{i_matrix, i_trans});
        ccrs.reset();
    }

    public static void renderLinks(TranslocatorPart p, CCRenderState ccrs, MatrixStack mStack, IRenderTypeBuffer getter) {
        double time = ClientUtils.getRenderTime();
        TileMultiPart tile = p.tile();
        if (p.a_eject) {
            Matrix4 mat = new Matrix4(mStack);
            ccrs.bind(particleType, getter);
            for (int dst = 0; dst < 6; ++dst) {
                TranslocatorPart p_dst;
                if (dst == p.side || !p.canConnect(dst) || (p_dst = (TranslocatorPart)tile.getSlottedPart(dst)).canEject()) continue;
                RenderTranslocator.renderLink(ccrs, mat, p.side, dst, time);
            }
        }
    }

    public static void renderFluid(FluidTranslocatorPart p, MatrixStack mStack, IRenderTypeBuffer getter, float delta) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(RenderUtils.getFluidRenderType(), getter);
        double time = ClientUtils.getRenderTime();
        Matrix4 mat = new Matrix4(mStack);
        for (FluidTranslocatorPart.MovingLiquid m : p.getMovingLiquids()) {
            double start = MathHelper.interpolate((double)m.b_start, (double)m.a_start, (double)delta);
            double end = MathHelper.interpolate((double)m.b_end, (double)m.a_end, (double)delta);
            RenderTranslocator.drawLiquidSpiral(ccrs, mat, p.side, m.dst, m.liquid, start, end, time, 0.0);
            if (!p.fast) continue;
            RenderTranslocator.drawLiquidSpiral(ccrs, mat, p.side, m.dst, m.liquid, start, end, time, 0.5);
        }
    }

    public static void renderItem(ItemTranslocatorPart p, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay, float delta) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        for (ItemTranslocatorPart.MovingItem m : p.movingItems) {
            mStack.func_227860_a_();
            double d = MathHelper.interpolate((double)m.b_progress, (double)m.a_progress, (double)delta);
            Vector3 path = RenderTranslocator.getPath(p.side, m.dst, d).add(RenderTranslocator.itemFloat(p.side, m.dst, d));
            mStack.func_227861_a_(path.x, path.y, path.z);
            mStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            mStack.func_227862_a_(0.35f, 0.35f, 0.35f);
            itemRenderer.func_229110_a_(m.stack, ItemCameraTransforms.TransformType.FIXED, packedLight, packedOverlay, mStack, getter);
            mStack.func_227865_b_();
        }
    }

    private static void renderLink(CCRenderState ccrs, Matrix4 mat, int src, int dst, double time) {
        double d = (time + (double)src + (double)(dst * 2)) % 10.0 / 6.0;
        for (int n = 0; n < 20; ++n) {
            double dn = d - (double)n * 0.1;
            int spriteX = (int)(7.0 - (double)n * 1.5 - d * 2.0);
            if (!MathHelper.between((double)0.0, (double)dn, (double)1.0) || spriteX < 0) continue;
            Vector3 pos = RenderTranslocator.getPath(src, dst, dn);
            double b = 1.0;
            double s = 1.0;
            double u1 = (double)spriteX / 8.0;
            double u2 = u1 + 0.125;
            double v1 = 0.0;
            double v2 = 1.0;
            RenderTranslocator.renderParticle(ccrs, mat.copy().translate(pos), gradient.getColour((dn - 0.5) * 1.2 + 0.5).multiplyC(b), s * 0.12, u1, v1, u2, v2);
        }
    }

    private static void drawLiquidSpiral(CCRenderState ccrs, Matrix4 mat, int src, int dst, FluidStack stack, double start, double end, double time, double theta0) {
        if (stack.isEmpty()) {
            return;
        }
        FluidAttributes attribs = stack.getFluid().getAttributes();
        RenderMaterial material = ForgeHooksClient.getBlockMaterial((ResourceLocation)attribs.getStillTexture(stack));
        TextureAtlasSprite tex = material.func_229314_c_();
        ccrs.colour = attribs.getColor(stack) << 8 | 0xFF;
        Vector3[] last = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        Vector3[] next = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        double tess = 0.05;
        Vector3 a = RenderTranslocator.getPerp(src, dst);
        boolean rev = RenderTranslocator.sum(a.copy().crossProduct(RenderTranslocator.getPathNormal(src, dst, 0.0))) != RenderTranslocator.sum(sideVec[src]);
        for (double di = end; di <= start; di += tess) {
            Vector3 b = RenderTranslocator.getPathNormal(src, dst, di);
            Vector3 c = RenderTranslocator.getPath(src, dst, di);
            if (rev) {
                b.negate();
            }
            double r = (2.0 * di - time / 10.0 + theta0 + (double)(dst / 6)) * 2.0 * Math.PI;
            double sz = 0.1;
            Vector3 p = c.add(a.copy().multiply(Math.sin(r) * sz)).add(b.copy().multiply(Math.cos(r) * sz));
            double s1 = 0.02;
            double s2 = -0.02;
            next[0].set(p).add(a.x * s1 + b.x * s1, a.y * s1 + b.y * s1, a.z * s1 + b.z * s1);
            next[1].set(p).add(a.x * s2 + b.x * s1, a.y * s2 + b.y * s1, a.z * s2 + b.z * s1);
            next[2].set(p).add(a.x * s2 + b.x * s2, a.y * s2 + b.y * s2, a.z * s2 + b.z * s2);
            next[3].set(p).add(a.x * s1 + b.x * s2, a.y * s1 + b.y * s2, a.z * s1 + b.z * s2);
            if (di > end) {
                double u1 = tex.func_94214_a(Math.abs(di) * 16.0);
                double u2 = tex.func_94214_a(Math.abs(di - tess) * 16.0);
                for (int i = 0; i < 4; ++i) {
                    int j = (i + 1) % 4;
                    Vector3 axis = next[j].copy().subtract(next[i]);
                    double v1 = tex.func_94207_b(Math.abs(next[i].scalarProject(axis)) * 16.0);
                    double v2 = tex.func_94207_b(Math.abs(next[j].scalarProject(axis)) * 16.0);
                    ccrs.vert.set(next[i], u1, v1).apply((Transformation)mat);
                    ccrs.writeVert();
                    ccrs.vert.set(next[j], u1, v2).apply((Transformation)mat);
                    ccrs.writeVert();
                    ccrs.vert.set(last[j], u2, v2).apply((Transformation)mat);
                    ccrs.writeVert();
                    ccrs.vert.set(last[i], u2, v1).apply((Transformation)mat);
                    ccrs.writeVert();
                }
            }
            Vector3[] tmp = last;
            last = next;
            next = tmp;
        }
    }

    public static void renderParticle(CCRenderState ccrs, Matrix4 mat, Colour colour, double s, double u1, double v1, double u2, double v2) {
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double rotationX = Math.cos((double)info.func_216778_f() * 0.017453292519943);
        double rotationZ = Math.sin((double)info.func_216778_f() * 0.017453292519943);
        double rotationYZ = -rotationZ * Math.sin((double)info.func_216777_e() * 0.017453292519943);
        double rotationXY = rotationX * Math.sin((double)info.func_216777_e() * 0.017453292519943);
        double rotationXZ = Math.cos((double)info.func_216777_e() * 0.017453292519943);
        ccrs.colour = colour.rgba();
        ccrs.vert.set(-rotationX * s - rotationYZ * s, -rotationXZ * s, -rotationZ * s - rotationXY * s, u2, v2).apply((Transformation)mat);
        ccrs.writeVert();
        ccrs.vert.set(-rotationX * s + rotationYZ * s, rotationXZ * s, -rotationZ * s + rotationXY * s, u2, v1).apply((Transformation)mat);
        ccrs.writeVert();
        ccrs.vert.set(rotationX * s + rotationYZ * s, rotationXZ * s, rotationZ * s + rotationXY * s, u1, v1).apply((Transformation)mat);
        ccrs.writeVert();
        ccrs.vert.set(rotationX * s - rotationYZ * s, -rotationXZ * s, rotationZ * s - rotationXY * s, u1, v2).apply((Transformation)mat);
        ccrs.writeVert();
    }

    public static Vector3 getPath(int src, int dst, double d) {
        Vector3 v;
        if ((src ^ 1) == dst) {
            v = sideVec[src ^ 1].copy().multiply(d);
        } else {
            Vector3 vsrc = sideVec[src ^ 1];
            Vector3 vdst = sideVec[dst ^ 1];
            Vector3 a = vsrc.copy().multiply(0.3125);
            Vector3 b = vdst.copy().multiply(0.375);
            double sind = Math.sin(d * Math.PI / 2.0);
            double cosd = Math.cos(d * Math.PI / 2.0);
            v = a.multiply(sind).add(b.multiply(cosd - 1.0)).add(vsrc.copy().multiply(0.1875));
        }
        return v.add(sidePos[src]);
    }

    private static Vector3 getPathNormal(int srcSide, int dstSide, double d) {
        if ((srcSide ^ 1) == dstSide) {
            return sideVec[(srcSide + 4) % 6].copy();
        }
        double sind = Math.sin(d * Math.PI / 2.0);
        double cosd = Math.cos(d * Math.PI / 2.0);
        Vector3 vsrc = sideVec[srcSide ^ 1].copy();
        Vector3 vdst = sideVec[dstSide ^ 1].copy();
        return vsrc.multiply(sind).add(vdst.multiply(cosd)).normalize();
    }

    private static Vector3 itemFloat(int src, int dst, double d) {
        return RenderTranslocator.getPerp(src, dst).multiply(0.01 * Math.sin(d * 4.0 * Math.PI));
    }

    public static Vector3 getPerp(int src, int dst) {
        if ((src ^ 1) == dst) {
            return sideVec[(src + 2) % 6].copy();
        }
        for (int i = 0; i < 3; ++i) {
            if (i == src / 2 || i == dst / 2) continue;
            return sideVec[i * 2].copy();
        }
        return null;
    }

    private static double sum(Vector3 v) {
        return v.x + v.y + v.z;
    }

    static {
        gradient = new CustomGradient(new ResourceLocation("translocators", "textures/fx/grad.png"));
        ITEM_RENDER_TYPE = RenderType.func_228634_a_((ResourceLocation)AtlasTexture.field_110575_b);
        particleType = RenderType.func_228632_a_((String)"translocator_link", (VertexFormat)DefaultVertexFormats.field_181709_i, (int)7, (int)255, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("translocators", "textures/fx/particle.png"), false, false)).func_228726_a_(RenderType.field_228515_g_).func_228727_a_(RenderType.field_228496_F_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
        Map models = OBJParser.parseModels((ResourceLocation)new ResourceLocation("translocators", "models/model_new.obj"), (int)7, (Transformation)new SwapYZ());
        RenderTranslocator.plates[0] = (CCModel)models.get("Plate");
        insert = (CCModel)models.get("Insert");
        CCModel.generateSidedModels((CCModel[])plates, (int)0, (Vector3)new Vector3());
        for (int i = 0; i < 6; ++i) {
            plates[i].computeLighting(LightModel.standardLightModel);
        }
    }
}

