/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.network;

import io.github.drmanganese.topaddons.TopAddons;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

class ElementSyncMessage {
    private final Map<String, Integer> elementIdMap;

    ElementSyncMessage(Map<String, Integer> elementIdMap) {
        this.elementIdMap = elementIdMap;
    }

    static ElementSyncMessage decode(PacketBuffer buf) {
        int size = buf.readInt();
        HashMap<String, Integer> elementIdMap = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            elementIdMap.put(buf.func_150789_c(Short.MAX_VALUE), buf.readInt());
        }
        return new ElementSyncMessage(elementIdMap);
    }

    static void onMessage(ElementSyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()).getCapability(TopAddons.ELT_SYNC_CAP).ifPresent(cap -> cap.setElementIds(msg.elementIdMap)));
    }

    void encode(PacketBuffer buf) {
        buf.writeInt(this.elementIdMap.size());
        this.elementIdMap.forEach((key, value) -> {
            buf.func_180714_a(key);
            buf.writeInt(value.intValue());
        });
    }
}

