/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.network;

import io.github.drmanganese.topaddons.TopAddons;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientConfigSyncMessage {
    private final Map<String, String> syncMap;

    ClientConfigSyncMessage(Map<String, String> syncMap) {
        this.syncMap = new HashMap<String, String>(syncMap.size());
        syncMap.forEach(this.syncMap::put);
    }

    static ClientConfigSyncMessage decode(PacketBuffer buf) {
        int size = buf.readInt();
        HashMap<String, String> syncMap = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            syncMap.put(buf.func_150789_c(Short.MAX_VALUE), buf.func_150789_c(Short.MAX_VALUE));
        }
        return new ClientConfigSyncMessage(syncMap);
    }

    static void onMessage(ClientConfigSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()).getCapability(TopAddons.CLIENT_CFG_CAP).ifPresent(cap -> cap.fromMap(message.syncMap)));
    }

    void encode(PacketBuffer buf) {
        buf.writeInt(this.syncMap.size());
        this.syncMap.forEach((key, value) -> {
            buf.func_180714_a(key);
            buf.func_180714_a(value);
        });
    }
}

