/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements.forge;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.drmanganese.topaddons.addons.forge.ForgeAddon;
import io.github.drmanganese.topaddons.client.FluidColorExtraction;
import io.github.drmanganese.topaddons.client.FluidColors;
import io.github.drmanganese.topaddons.util.ElementHelper;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidGaugeElement
implements IElement {
    private static final int INNER_WIDTH = 98;
    private static final int INNER_HEIGHT = 6;
    private static final int INNER_HEIGHT_EXTENDED = 10;
    private final boolean extended;
    private final long amount;
    private final long capacity;
    private final String tankNameKey;
    private final Fluid fluid;
    private int id;

    public FluidGaugeElement(int id, boolean extended, long amount, long capacity, String tankNameKey, Fluid fluid) {
        this.id = id;
        this.extended = extended;
        this.amount = amount;
        this.capacity = capacity;
        this.tankNameKey = tankNameKey;
        this.fluid = fluid;
    }

    public FluidGaugeElement(PacketBuffer buf) {
        this.extended = buf.readBoolean();
        this.amount = buf.readLong();
        this.capacity = buf.readLong();
        this.tankNameKey = buf.func_218666_n();
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(buf.func_218666_n()));
    }

    public void render(MatrixStack stack, int x, int y) {
        int borderColor = ForgeAddon.gaugeBorderColor.getInt();
        int backgroundColor = ForgeAddon.gaugeBackgroundColor.getInt();
        int fluidColor = ImmutableList.of(FluidColors.getOverrideColor(this.fluid), FluidColors.getForgeColor(this.fluid)).stream().filter(Optional::isPresent).findFirst().flatMap(Function.identity()).orElse(FluidColors.getForFluid(this.fluid, (ForgeAddon.FluidColorAlgorithm)((Object)ForgeAddon.gaugeFluidColorAlgorithm.get())));
        this.renderBackground(stack, x, y, borderColor, backgroundColor);
        if (((Boolean)ForgeAddon.gaugeRenderFluidTexture.get()).booleanValue()) {
            try {
                this.renderFluid(stack, x + 1, y + 1, this.fluid);
            }
            catch (NullPointerException e) {
                this.renderFluid(stack, x + 1, y + 1, fluidColor);
            }
        } else {
            this.renderFluid(stack, x + 1, y + 1, fluidColor);
        }
        this.renderForeGround(stack, x, y, borderColor);
        this.renderText(stack, x, y, fluidColor);
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return this.extended ? 18 : 8;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.extended);
        buf.writeLong(this.amount);
        buf.writeLong(this.capacity);
        buf.func_180714_a(this.tankNameKey);
        buf.func_180714_a(this.fluid.getRegistryName().toString());
    }

    public int getID() {
        return this.id;
    }

    private static float red(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float green(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float blue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private static float alpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    private void renderBackground(MatrixStack matrixStack, int x, int y, int borderColor, int backgroundColor) {
        if (((Boolean)ForgeAddon.gaugeRounded.get()).booleanValue()) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)(y + 1), (int)(x + 98 + 1), (int)(y + (this.extended ? 11 : 7)), (int)backgroundColor);
            ElementHelper.drawHorizontalLine(matrixStack, x + (this.extended ? 2 : 1), y, this.extended ? 96 : 98, borderColor);
            ElementHelper.drawHorizontalLine(matrixStack, x + (this.extended ? 2 : 1), y + (this.extended ? 11 : 7), this.extended ? 96 : 98, borderColor);
            ElementHelper.drawVerticalLine(matrixStack, x, y + (this.extended ? 2 : 1), this.extended ? 8 : 6, borderColor);
            ElementHelper.drawVerticalLine(matrixStack, x + 99, y + (this.extended ? 2 : 1), this.extended ? 8 : 6, borderColor);
        } else {
            ElementHelper.drawBox(matrixStack, x, y, this.getWidth(), this.extended ? 12 : 8, backgroundColor, 1, borderColor);
        }
    }

    private void renderFluid(MatrixStack matrixStack, int x, int y, int color) {
        color = color & 0xFFFFFF | (Integer)ForgeAddon.gaugeFluidColorTransparency.get() << 24;
        int darkerColor = new Color(color, true).darker().hashCode();
        int i = 0;
        while ((long)i < Math.min(98L * this.amount / this.capacity, 98L)) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + i), (int)y, (int)(x + i + 1), (int)(y + (this.extended ? 10 : 6)), (int)(i % 2 == 0 ? color : darkerColor));
            ++i;
        }
    }

    private void renderFluid(MatrixStack matrixStack, int x, int y, Fluid fluid) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        TextureAtlasSprite texture = FluidColorExtraction.getStillFluidTextureSafe(fluid);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.func_229241_m_().func_229223_g_());
        int textureWidth = texture.func_94211_a();
        float minU = texture.func_94209_e();
        float maxU = texture.func_94212_f();
        float minV = texture.func_94206_g();
        float maxV = texture.func_94210_h();
        int tileHeight = this.extended ? 10 : 6;
        float vHeight = (maxV - minV) * 1.0f * (float)tileHeight / (float)texture.func_94216_b();
        float v1 = ((ForgeAddon.FluidTextureAlignment)((Object)ForgeAddon.gaugeFluidTextureAlignment.get())).fv1.apply(Float.valueOf(minV), Float.valueOf(maxV), Float.valueOf(vHeight)).floatValue();
        float v2 = ((ForgeAddon.FluidTextureAlignment)((Object)ForgeAddon.gaugeFluidTextureAlignment.get())).fv2.apply(Float.valueOf(minV), Float.valueOf(maxV), Float.valueOf(vHeight)).floatValue();
        RenderSystem.enableBlend();
        int fluidColor = fluid.getAttributes().getColor();
        RenderSystem.color4f((float)FluidGaugeElement.red(fluidColor), (float)FluidGaugeElement.green(fluidColor), (float)FluidGaugeElement.blue(fluidColor), (float)FluidGaugeElement.alpha(fluidColor));
        int fullWidth = (int)Math.min(98L, 98L * this.amount / this.capacity);
        int nTiles = (fullWidth + textureWidth - 1) / textureWidth;
        for (int tile = 0; tile < nTiles; ++tile) {
            int w = tile == nTiles - 1 ? fullWidth % textureWidth : textureWidth;
            this.drawFluidTiles(x + tile * textureWidth, y, w, tileHeight, minU, minU + (maxU - minU) * (1.0f * (float)w / (float)textureWidth), v1, v2, tessellator, buffer);
        }
        RenderSystem.disableBlend();
    }

    private void drawFluidTiles(int x, int y, int w, int h, float u1, float u2, float v1, float v2, Tessellator tessellator, BufferBuilder buffer) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + h), 0.0).func_225583_a_(u1, v2).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225583_a_(u2, v2).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)y, 0.0).func_225583_a_(u2, v1).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(u1, v1).func_181675_d();
        tessellator.func_78381_a();
    }

    private void renderForeGround(MatrixStack matrixStack, int x, int y, int borderColor) {
        if (this.extended) {
            if (((Boolean)ForgeAddon.gaugeRounded.get()).booleanValue()) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)(y + 1), (int)(x + 2), (int)(y + 2), (int)borderColor);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)(y + 10), (int)(x + 2), (int)(y + 11), (int)borderColor);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 98), (int)(y + 1), (int)(x + 99), (int)(y + 2), (int)borderColor);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 98), (int)(y + 10), (int)(x + 99), (int)(y + 11), (int)borderColor);
            }
            int[] gaugeLineXs = new int[]{13, 25, 37, 49, 61, 73, 85};
            int[] gaugeLineLengths = new int[]{5, 6, 5, 10, 5, 6, 5};
            for (int i = 0; i < gaugeLineXs.length; ++i) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + gaugeLineXs[i]), (int)(y + 1), (int)(x + gaugeLineXs[i] + 1), (int)(y + 1 + gaugeLineLengths[i]), (int)borderColor);
            }
        }
    }

    private void renderText(MatrixStack matrixStack, int x, int y, int color) {
        String tankDisplayName = new TranslationTextComponent(this.tankNameKey).getString();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (this.extended) {
            String fluidDisplayName = new TranslationTextComponent(this.fluid.getAttributes().getTranslationKey()).getString();
            font.func_238405_a_(matrixStack, this.amountText(), (float)(x + 3), (float)(y + 2), -1);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            font.func_238405_a_(matrixStack, tankDisplayName, (float)(x * 2), (float)((y + 13) * 2), -1);
            if (this.fluid != Fluids.field_204541_a) {
                font.func_238405_a_(matrixStack, fluidDisplayName, (float)((x + this.getWidth()) * 2 - font.func_78256_a(fluidDisplayName)), (float)((y + 13) * 2), color);
            }
            matrixStack.func_227865_b_();
        } else {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            font.func_238405_a_(matrixStack, tankDisplayName, (float)((x + 2) * 2), (float)((y + 2) * 2), -1);
            matrixStack.func_227865_b_();
        }
    }

    private String amountText() {
        if (this.amount == 0L && !((Boolean)ForgeAddon.gaugeShowCapacity.get()).booleanValue()) {
            return new TranslationTextComponent("topaddons.forge:empty").getString();
        }
        String amount = new DecimalFormat("#.#").format(this.capacity < 100000L ? this.amount : this.amount / 1000L);
        long capacity = this.capacity < 100000L ? this.capacity : this.capacity / 1000L;
        String unit = this.capacity < 100000L ? "mB" : "B";
        Boolean showCapacity = (Boolean)ForgeAddon.gaugeShowCapacity.get();
        return String.format("%s%s%s %s", amount, showCapacity != false ? "/" : "", showCapacity != false ? Long.valueOf(capacity) : "", unit);
    }
}

