/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.vanilla.tiles;

import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.styles.Styles;
import java.util.Objects;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BeaconInfo
implements ITileInfo<BeaconTileEntity> {
    private static final IIconStyle SMALL_ICON_STYLE = new IconStyle().bounds(8, 8).textureBounds(8, 8);
    private static final IIconStyle FULL_ICON_STYLE = new IconStyle().bounds(18, 18).textureBounds(18, 18);
    private static final ILayoutStyle FULL_LAYOUT_STYLE = Styles.CENTERED.copy().spacing(2);

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull BeaconTileEntity tile) {
        int level = tile.func_191979_s();
        if (level == 0) {
            return;
        }
        probeInfo.text(CompoundText.createLabelInfo((String)"Level: ", (Object)level));
        Effect primaryEffect = Effect.func_188412_a((int)tile.field_213937_n.func_221476_a(1));
        Effect secondaryEffect = Effect.func_188412_a((int)tile.field_213937_n.func_221476_a(2));
        if (primaryEffect != null) {
            IProbeInfo layout;
            IProbeInfo iProbeInfo = layout = probeMode == ProbeMode.EXTENDED ? probeInfo : probeInfo.horizontal();
            if (primaryEffect == secondaryEffect) {
                this.drawEffectIcon(layout, primaryEffect, "II", probeMode);
            } else {
                this.drawEffectIcon(layout, primaryEffect, "I", probeMode);
                if (secondaryEffect != null) {
                    this.drawEffectIcon(layout, secondaryEffect, "I", probeMode);
                }
            }
        }
    }

    private void drawEffectIcon(IProbeInfo probeInfo, Effect effect, String level, ProbeMode mode) {
        if (mode == ProbeMode.EXTENDED) {
            this.drawEffectIconAndName(probeInfo, effect, level);
        } else {
            this.drawEffectIcon(probeInfo, effect, SMALL_ICON_STYLE);
        }
    }

    private void drawEffectIconAndName(IProbeInfo probeInfo, Effect effect, String level) {
        IProbeInfo horizontal = probeInfo.horizontal(FULL_LAYOUT_STYLE);
        this.drawEffectIcon(horizontal, effect, FULL_ICON_STYLE).text(CompoundText.create().text(effect.func_199286_c()).text(" " + level));
    }

    private IProbeInfo drawEffectIcon(IProbeInfo probeInfo, Effect effect, IIconStyle style) {
        return probeInfo.icon(this.getEffectIconRL(effect), 0, 0, style.getTextureWidth(), style.getTextureHeight(), style);
    }

    private ResourceLocation getEffectIconRL(Effect effect) {
        String effectName = Objects.requireNonNull(effect.getRegistryName()).func_110623_a();
        return new ResourceLocation("minecraft:textures/mob_effect/" + effectName + ".png");
    }
}

