/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.vanilla.blocks;

import io.github.drmanganese.topaddons.api.IBlockInfo;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.styles.Styles;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.world.World;

public class BeehiveInfo
implements IBlockInfo,
ITileInfo<BeehiveTileEntity> {
    public static final BeehiveInfo INSTANCE = new BeehiveInfo();
    public static final int MAX_HONEY_LEVEL = BlockStateProperties.field_227036_ao_.func_177700_c().stream().max(Integer::compareTo).orElse(5);

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData) {
        int honeyLevel = (Integer)blockState.func_177229_b((Property)BlockStateProperties.field_227036_ao_);
        IProgressStyle progressStyle = Styles.machineProgress(player, "Honey").filledColor(-271243).alternateFilledColor(-537018).alignment(ElementAlignment.ALIGN_CENTER).suffix("/" + MAX_HONEY_LEVEL);
        probeInfo.progress(honeyLevel, MAX_HONEY_LEVEL, progressStyle);
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull BeehiveTileEntity tile) {
        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity("minecraft:bee", probeInfo.defaultEntityStyle()).text(CompoundText.create().label("topaddons.vanilla:bees").text(": ").style(TextStyleClass.INFO).text(String.valueOf(tile.func_226971_j_())));
    }
}

