/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.thermal.tiles;

import cofh.thermal.lib.tileentity.ThermalTileAugmentable;
import com.google.common.collect.ImmutableMap;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.styles.Styles;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class MachineTileInfo
implements ITileInfo<ThermalTileAugmentable> {
    public static final MachineTileInfo INSTANCE = new MachineTileInfo();
    private static final ImmutableMap<String, Styles.Colors> MACHINE_COLORS = new ImmutableMap.Builder().put((Object)"thermal:machine_crucible", (Object)Styles.Colors.fromDye(DyeColor.ORANGE)).put((Object)"thermal:machine_chiller", (Object)Styles.Colors.fromDye(DyeColor.BLUE)).put((Object)"thermal:machine_brewer", (Object)Styles.Colors.fromDye(DyeColor.PURPLE)).put((Object)"thermal:machine_pyrolyzer", (Object)Styles.Colors.fromDye(DyeColor.GREEN)).put((Object)"thermal:machine_sawmill", (Object)Styles.Colors.fromDye(DyeColor.BROWN)).put((Object)"thermal:machine_insolator", (Object)Styles.Colors.fromDye(DyeColor.YELLOW)).put((Object)"thermal:machine_furnace", (Object)Styles.Colors.fromDye(DyeColor.RED)).build();

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull ThermalTileAugmentable tile) {
        if (tile.isActive) {
            Styles.Colors color = (Styles.Colors)MACHINE_COLORS.getOrDefault((Object)blockState.func_177230_c().getRegistryName().toString(), (Object)Styles.Colors.fromDye(DyeColor.GRAY));
            IProgressStyle progressStyle = Styles.machineProgress(player).filledColor(color.dyeColor).alternateFilledColor(color.darkerColor);
            probeInfo.progress(tile.getScaledProgress(100), 100, progressStyle);
            int consumption = tile.getCurSpeed();
            if (consumption > 0) {
                probeInfo.text(CompoundText.createLabelInfo((String)"{*topaddons.thermal_expansion:consumption*}: ", (Object)consumption).label((ITextComponent)new StringTextComponent(" RF/t")));
            }
        }
    }
}

