/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.thermal.tiles;

import cofh.thermal.core.tileentity.storage.EnergyCellTile;
import io.github.drmanganese.topaddons.addons.thermal.ThermalExpansionAddon;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.config.Config;
import io.github.drmanganese.topaddons.styles.Styles;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class EnergyCellTileInfo
implements ITileInfo<EnergyCellTile> {
    private static final ILayoutStyle ICON_LAYOUT_STYLE = Styles.CENTERED.copy().spacing(1);
    private static final IIconStyle ICON_STYLE = new IconStyle().bounds(10, 10).textureBounds(16, 16);
    private static final ResourceLocation INPUT_ICON = new ResourceLocation("cofh_core:textures/gui/icons/icon_input.png");
    private static final ResourceLocation OUTPUT_ICON = new ResourceLocation("cofh_core:textures/gui/icons/icon_output.png");

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull EnergyCellTile tile) {
        if (probeMode == ProbeMode.EXTENDED || Config.getSyncedBoolean(player, ThermalExpansionAddon.alwaysShowCellIo)) {
            EnergyCellTileInfo.ioIcon(probeInfo, tile.amountInput, INPUT_ICON);
            EnergyCellTileInfo.ioIcon(probeInfo, tile.amountOutput, OUTPUT_ICON);
        }
    }

    private static void ioIcon(IProbeInfo probeInfo, int amount, ResourceLocation icon) {
        probeInfo.horizontal(ICON_LAYOUT_STYLE).icon(icon, 3, 3, 13, 13, ICON_STYLE).text(CompoundText.create().label((ITextComponent)new StringTextComponent(String.format("%d RF/t", amount))));
    }
}

