/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.storagedrawers.tiles;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import io.github.drmanganese.topaddons.addons.storagedrawers.StorageDrawersAddon;
import io.github.drmanganese.topaddons.api.ITileConfigProvider;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.config.Config;
import io.github.drmanganese.topaddons.util.InfoHelper;
import io.github.drmanganese.topaddons.util.PlayerHelper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class DrawerInfo
implements ITileInfo<TileEntityDrawers>,
ITileConfigProvider {
    private static final String INFINITY = "\u221e";
    private static final ILayoutStyle NO_SPACING = new LayoutStyle().spacing(0);
    private static final ILayoutStyle INVENTORY = new LayoutStyle().spacing(2).borderColor(Integer.valueOf(mcjty.theoneprobe.config.Config.chestContentsBorderColor));

    @Override
    public void getProbeConfig(IProbeConfig config, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntityDrawers tile = Objects.requireNonNull((TileEntityDrawers)world.func_175625_s(data.getPos()));
        if (DrawerInfo.shouldShowInfo(PlayerHelper.getProbeMode(player), player) || DrawerInfo.hideInfoBecauseConcealed(tile)) {
            config.showChestContents(IProbeConfig.ConfigMode.NOT);
        }
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull TileEntityDrawers tile) {
        if (!DrawerInfo.shouldShowInfo(probeMode, player) || DrawerInfo.hideInfoBecauseConcealed(tile)) {
            return;
        }
        IDrawerGroup drawerGroup = tile.getGroup();
        List<IDrawer> drawers = IntStream.range(0, drawerGroup.getDrawerCount()).mapToObj(arg_0 -> ((IDrawerGroup)drawerGroup).getDrawer(arg_0)).filter(d -> !d.isEmpty()).collect(Collectors.toList());
        if (!drawers.isEmpty()) {
            boolean hasVendingUpgrade = tile.getDrawerAttributes().isUnlimitedVending();
            IProbeInfo vert = probeInfo.vertical(INVENTORY);
            drawers.forEach(drawer -> DrawerInfo.displayDrawerInfo(vert, drawer, hasVendingUpgrade));
        }
        if (probeMode == ProbeMode.EXTENDED) {
            boolean hasUnlimitedStorage = tile.getDrawerAttributes().isUnlimitedStorage();
            int storageMultiplier = tile.upgrades().getStorageMultiplier();
            int stacksPerSlot = tile.getEffectiveDrawerCapacity() * storageMultiplier;
            InfoHelper.textPrefixed(probeInfo, "{*topaddons.storagedrawers:stack_limit*}", hasUnlimitedStorage ? INFINITY : stacksPerSlot + " (x" + storageMultiplier + ")");
        }
    }

    private static void displayDrawerInfo(IProbeInfo probeInfo, IDrawer drawer, Boolean hasVendingUpgrade) {
        IProbeInfo horizontal = probeInfo.horizontal(NO_SPACING);
        ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
        stack.func_190920_e(Math.max(1, drawer.getStoredItemCount()));
        horizontal.item(stack);
        IProbeInfo vertical = horizontal.vertical(NO_SPACING);
        vertical.itemLabel(drawer.getStoredItemPrototype());
        vertical.text(CompoundText.create().style(TextStyleClass.LABEL).text(String.format("[%s]", hasVendingUpgrade != false ? INFINITY : DrawerInfo.getDetailedCount(drawer))));
    }

    private static String getDetailedCount(IDrawer drawer) {
        int count = drawer.getStoredItemCount();
        int stackSize = drawer.getStoredItemStackSize();
        int stacks = count / stackSize;
        int remainder = count % stackSize;
        if (stackSize == 1 || count < stackSize) {
            return String.valueOf(count);
        }
        String detailedCount = String.format("%dx%d", stacks, stackSize);
        if (remainder > 0) {
            detailedCount = detailedCount + String.format(" + %d", remainder);
        }
        return detailedCount;
    }

    private static boolean hideInfoBecauseConcealed(TileEntityDrawers tile) {
        return tile.getDrawerAttributes().isConcealed() && (Boolean)StorageDrawersAddon.hideConcealed.get() != false;
    }

    private static boolean shouldShowInfo(ProbeMode probeMode, PlayerEntity player) {
        return probeMode == ProbeMode.EXTENDED || Config.getSyncedBoolean(player, StorageDrawersAddon.alwaysShowExtended);
    }
}

