/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.industrialforegoing.tiles;

import com.buuz135.industrial.block.generator.tile.MycelialGeneratorTile;
import com.google.common.collect.LinkedHashMultimap;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block.tile.GeneratorTile;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import io.github.drmanganese.topaddons.addons.industrialforegoing.IndustrialForegoingAddon;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.config.Config;
import io.github.drmanganese.topaddons.styles.Styles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.commons.lang3.ClassUtils;

public class IndustrialActiveTileInfo
implements ITileInfo<ActiveTile<?>> {
    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull ActiveTile<?> tile) {
        ProgressBars.getForTile(tile).filter(progressBarHolder -> !(tile instanceof MycelialGeneratorTile) || !progressBarHolder.fieldName.equals("bar")).forEach(progressBarHolder -> {
            ProgressBarComponent<?> progressBar = progressBarHolder.progressBar;
            if (tile instanceof GeneratorTile) {
                GeneratorTile generatorTile = (GeneratorTile)tile;
                if (progressBar.getProgress() > 0) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"{*topaddons:generating*}: ", (Object)generatorTile.getEnergyProducedEveryTick()).label(" FE/t"));
                }
                IndustrialActiveTileInfo.tinyIndustrialProgressBar(probeInfo, player, probeMode, progressBar);
                return;
            }
            switch (progressBarHolder.fieldName) {
                case "work": 
                case "workingBar": 
                case "red": 
                case "green": 
                case "blue": 
                case "bar": 
                case "blaze": {
                    IndustrialActiveTileInfo.tinyIndustrialProgressBar(probeInfo, player, probeMode, progressBar);
                    break;
                }
                case "progressBar": {
                    IndustrialActiveTileInfo.industrialProgressBar(probeInfo, player, progressBar);
                    break;
                }
                case "etherBuffer": {
                    IndustrialActiveTileInfo.tinyIndustrialProgressBar(probeInfo, player, progressBar, -5385004, -8809324, 863605908);
                    break;
                }
            }
        });
    }

    private static void industrialProgressBar(IProbeInfo probeInfo, PlayerEntity player, ProgressBarComponent<?> progressBar) {
        Predicate canIncrease = progressBar.getCanIncrease();
        if (!canIncrease.test((ActiveTile)progressBar.getComponentHarness()) && progressBar.getProgress() == 0) {
            return;
        }
        Styles.Colors colors = Styles.Colors.fromDye(progressBar.getColor() == DyeColor.WHITE ? DyeColor.LIGHT_GRAY : progressBar.getColor());
        IProgressStyle style = Styles.machineProgress(player).filledColor(colors.dyeColor).alternateFilledColor(colors.darkerColor).alignment(ElementAlignment.ALIGN_CENTER);
        int progressScaled = 100 * progressBar.getProgress() / progressBar.getMaxProgress();
        probeInfo.progress(progressScaled, 100, style);
    }

    private static void tinyIndustrialProgressBar(IProbeInfo probeInfo, PlayerEntity player, ProbeMode probeMode, ProgressBarComponent<?> progressBar) {
        if (progressBar.getProgress() == 0 && probeMode == ProbeMode.NORMAL) {
            return;
        }
        Styles.Colors colors = Styles.Colors.fromDye(progressBar.getColor());
        IndustrialActiveTileInfo.tinyIndustrialProgressBar(probeInfo, player, progressBar, colors.dyeColor, colors.darkerColor, colors.semiTransparentColor);
    }

    private static void tinyIndustrialProgressBar(IProbeInfo probeInfo, PlayerEntity player, ProgressBarComponent<?> progressBar, int filledColor, int alternateFilledColor, int backgroundColor) {
        IProgressStyle style = Styles.machineProgress(player).showText(false).height(probeInfo.defaultProgressStyle().getHeight() / 2).filledColor(filledColor).alternateFilledColor(alternateFilledColor);
        if (Config.getSyncedBoolean(player, IndustrialForegoingAddon.colorTinyProgressBackground)) {
            style.backgroundColor(backgroundColor);
        }
        probeInfo.progress(progressBar.getProgress(), progressBar.getMaxProgress(), style);
    }

    public static class ProgressBars {
        private static final LinkedHashMultimap<Class<?>, Field> FIELDS = LinkedHashMultimap.create();
        private static final Set<Field> EMPTY_SET = new HashSet<Field>();
        private static final List<Class> IGNORE = new ArrayList<Class>();

        public static Stream<ProgressBarHolder> getForTile(TileEntity tile) {
            return ProgressBars.getFieldsForClass(tile.getClass()).stream().map(field -> ProgressBars.getProgressBarHolder(field, tile)).filter(Optional::isPresent).map(Optional::get);
        }

        private static Optional<ProgressBarHolder> getProgressBarHolder(Field field, TileEntity tile) {
            try {
                return Optional.ofNullable(field.get(tile)).map(progressBarComponent -> new ProgressBarHolder(field.getName(), (ProgressBarComponent)progressBarComponent));
            }
            catch (IllegalAccessException e) {
                return Optional.empty();
            }
        }

        private static Set<Field> getFieldsForClass(Class<?> clazz) {
            if (FIELDS.containsKey(clazz)) {
                return FIELDS.get(clazz);
            }
            if (IGNORE.contains(clazz)) {
                return EMPTY_SET;
            }
            ProgressBars.findProgressBarsForClass(clazz);
            return ProgressBars.getFieldsForClass(clazz);
        }

        private static void findProgressBarsForClass(Class<?> clazz) {
            Predicate<Field> fieldPredicate = field -> field.getType() == ProgressBarComponent.class;
            List<Field> fields = Stream.concat(ClassUtils.getAllSuperclasses(clazz).stream().map(Class::getDeclaredFields).flatMap(Arrays::stream), Arrays.stream(clazz.getDeclaredFields())).filter(fieldPredicate).sorted((f1, f2) -> f1.getName().equals("progressBar") ? 1 : (f2.getName().equals("progressBar") ? -1 : f1.getName().compareTo(f2.getName()))).collect(Collectors.toList());
            if (fields.isEmpty()) {
                IGNORE.add(clazz);
            } else {
                fields.forEach(field -> {
                    field.setAccessible(true);
                    FIELDS.put((Object)clazz, field);
                });
            }
        }

        private static class ProgressBarHolder {
            final String fieldName;
            final ProgressBarComponent<?> progressBar;

            private ProgressBarHolder(String fieldName, ProgressBarComponent<?> progressBar) {
                this.fieldName = fieldName;
                this.progressBar = progressBar;
            }
        }
    }
}

