/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.forge.tiles;

import io.github.drmanganese.topaddons.addons.forge.ForgeAddon;
import io.github.drmanganese.topaddons.api.ITileConfigProvider;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.capabilities.ElementSync;
import io.github.drmanganese.topaddons.config.Config;
import io.github.drmanganese.topaddons.elements.forge.FluidGaugeElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidHandlerTileInfo
implements ITileInfo<TileEntity>,
ITileConfigProvider {
    public static final FluidHandlerTileInfo INSTANCE = new FluidHandlerTileInfo();
    public static final Map<String, String> CUSTOM_TANK_KEYS = new HashMap<String, String>();

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull TileEntity tile) {
        if (ForgeAddon.FluidGaugeChoice.getSyncedValueFor((PlayerEntity)player).hideTopAddonsGauge) {
            return;
        }
        Block block = blockState.func_177230_c();
        if (!((List)ForgeAddon.gaugeModBlacklist.get()).contains(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).func_110624_b())) {
            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                IntFunction<FluidTank> tankMaker = i -> new FluidTank((IFluidHandler)fluidHandler, block, i, player);
                IntStream.range(0, fluidHandler.getTanks()).mapToObj(tankMaker).filter(rec$ -> ((FluidTank)rec$).isValidTank()).map(rec$ -> ((FluidTank)rec$).elementMaker()).forEachOrdered(maker -> probeInfo.element((IElement)maker.apply(player, probeMode)));
            });
        }
    }

    @Override
    public void getProbeConfig(IProbeConfig config, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        if (ForgeAddon.FluidGaugeChoice.getSyncedValueFor((PlayerEntity)player).hideOriginal) {
            config.showTankSetting(IProbeConfig.ConfigMode.NOT);
        }
    }

    static {
        CUSTOM_TANK_KEYS.put("thermal:machine_refinery", "topaddons.thermal:fractioning_still");
    }

    private static class FluidTank {
        private final FluidStack stack;
        private final long capacity;
        private final String translationKey;
        private final int elementId;

        private FluidTank(IFluidHandler handler, Block block, int tankIndex, PlayerEntity player) {
            this.stack = handler.getFluidInTank(tankIndex);
            this.capacity = handler.getTankCapacity(tankIndex);
            this.translationKey = this.getTranslationKey(block.getRegistryName().toString(), tankIndex, player);
            this.elementId = ElementSync.getId("fluid_gauge", player);
        }

        private BiFunction<PlayerEntity, ProbeMode, FluidGaugeElement> elementMaker() {
            return (player, mode) -> new FluidGaugeElement(this.elementId, mode == ProbeMode.EXTENDED, this.stack.getAmount(), this.capacity, this.translationKey, this.stack.getFluid());
        }

        private String getTranslationKey(String registryName, int tankIndex, PlayerEntity player) {
            if (CUSTOM_TANK_KEYS.containsKey(registryName) && Config.getSyncedBoolean(player, ForgeAddon.gaugeUseCustomTankNames)) {
                return String.format("%s_%d", CUSTOM_TANK_KEYS.get(registryName), tankIndex);
            }
            return "topaddons.forge:default_tank_name";
        }

        private Boolean isValidTank() {
            return this.capacity > 0L;
        }
    }
}

