/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.bloodmagic.tiles;

import io.github.drmanganese.topaddons.addons.bloodmagic.BloodMagicAddon;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.capabilities.ElementSync;
import io.github.drmanganese.topaddons.elements.bloodmagic.BloodAltarProgressElement;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import wayoftime.bloodmagic.altar.BloodAltar;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.tile.TileAltar;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class TileAltarInfo
implements ITileInfo<TileAltar> {
    private static Field bloodAltarField;
    private static Field recipeField;

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull TileAltar tile) {
        probeInfo.text(CompoundText.createLabelInfo((String)"{*topaddons.bloodmagic:tier*}: ", (Object)tile.getTier()));
        if (((Boolean)BloodMagicAddon.altarsRequireSigil.get()).booleanValue() && !BloodMagicAddon.isHoldingSigil(player)) {
            return;
        }
        ItemStack inputStack = tile.func_70301_a(0);
        if (inputStack.func_190926_b()) {
            return;
        }
        if (inputStack.func_77973_b() instanceof IBloodOrb) {
            Binding binding = ((IBindable)inputStack.func_77973_b()).getBinding(inputStack);
            if (binding != null) {
                SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)binding.getOwnerId());
                BloodOrb orb = ((IBloodOrb)inputStack.func_77973_b()).getOrb(inputStack);
                TileAltarInfo.addAltarCraftingElement(probeInfo, player, network.getCurrentEssence(), orb.getCapacity(), inputStack, ItemStack.field_190927_a, 0.0f);
            }
        } else if (tile.isActive()) {
            Optional<BloodAltar> bloodAltar = TileAltarInfo.getBloodAltar(tile);
            Optional<ItemStack> recipe = bloodAltar.flatMap(TileAltarInfo::getRecipe);
            recipe.map(RecipeBloodAltar::getOutput).ifPresent(outputStack -> TileAltarInfo.addAltarCraftingElement(probeInfo, player, tile.getProgress(), tile.getLiquidRequired() * inputStack.func_190916_E(), inputStack, outputStack, tile.getConsumptionRate()));
        }
    }

    private static void addAltarCraftingElement(IProbeInfo probeInfo, PlayerEntity player, int progress, int maxProgress, ItemStack inputStack, ItemStack outputStack, float consumption) {
        probeInfo.element((IElement)new BloodAltarProgressElement(ElementSync.getId("bm_altar_progress", player), progress, maxProgress, inputStack, outputStack, consumption));
    }

    private static Optional<BloodAltar> getBloodAltar(TileAltar tile) {
        return Optional.ofNullable(bloodAltarField).flatMap(field -> {
            try {
                return Optional.of((BloodAltar)field.get(tile));
            }
            catch (IllegalAccessException ignored) {
                return Optional.empty();
            }
        });
    }

    private static Optional<RecipeBloodAltar> getRecipe(BloodAltar bloodAltar) {
        return Optional.ofNullable(recipeField).flatMap(field -> {
            try {
                return Optional.ofNullable((RecipeBloodAltar)field.get(bloodAltar));
            }
            catch (IllegalAccessException ignored) {
                return Optional.empty();
            }
        });
    }

    static {
        try {
            bloodAltarField = TileAltar.class.getDeclaredField("bloodAltar");
            bloodAltarField.setAccessible(true);
            recipeField = BloodAltar.class.getDeclaredField("recipe");
            recipeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

