/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.gigaherz.toolbelt.belt.ToolBeltInventory;
import dev.gigaherz.toolbelt.common.Screens;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import dev.gigaherz.toolbelt.customslots.IExtensionContainer;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import dev.gigaherz.toolbelt.customslots.IExtensionSlotItem;
import dev.gigaherz.toolbelt.customslots.example.RpgEquipment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ToolBeltItem
extends Item
implements IExtensionSlotItem {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER;
    @CapabilityInject(value=IExtensionSlotItem.class)
    public static Capability<IExtensionSlotItem> EXTENSION_SLOT_ITEM;
    @Nullable
    @CapabilityInject(value=ICurio.class)
    public static Capability<ICurio> CURIO_ITEM;
    public static final ImmutableSet<ResourceLocation> BELT_SLOT_LIST;
    public static int[] xpCost;

    public ToolBeltItem(Item.Properties properties) {
        super(properties);
    }

    private static int getSlotFor(PlayerInventory inv, ItemStack stack) {
        if (inv.func_70448_g() == stack) {
            return inv.field_70461_c;
        }
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            ItemStack invStack = (ItemStack)inv.field_70462_a.get(i);
            if (invStack != stack) continue;
            return i;
        }
        return -1;
    }

    private ActionResultType openBeltScreen(@Nullable PlayerEntity player, ItemStack stack, World world) {
        int slot;
        int n = slot = player != null ? ToolBeltItem.getSlotFor(player.field_71071_by, stack) : -1;
        if (slot == -1) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            Screens.openBeltScreen((ServerPlayerEntity)player, slot);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_221531_n() != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        return this.openBeltScreen(context.func_195999_j(), context.func_195996_i(), context.func_195991_k());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != Hand.MAIN_HAND) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        ActionResultType result = this.openBeltScreen(player, stack, world);
        return new ActionResult(result, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int size = ToolBeltItem.getSlotsCount(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("text.toolbelt.tooltip", new Object[]{size - 2, size}));
    }

    @Override
    @Nonnull
    public ImmutableSet<ResourceLocation> getAcceptableSlots(@Nonnull ItemStack stack) {
        return BELT_SLOT_LIST;
    }

    @Override
    public void onWornTick(ItemStack itemstack, IExtensionSlot slot) {
        this.tickAllSlots(itemstack, slot.getContainer().getOwner());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            this.tickAllSlots(stack, (LivingEntity)entityIn);
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        return new ICapabilityProvider(){
            final ItemStack owner;
            final ToolBeltInventory itemHandler;
            final LazyOptional<IItemHandler> itemHandlerInstance;
            final LazyOptional<IExtensionSlotItem> extensionSlotInstance;
            final LazyOptional<ICurio> curioItemInstance;
            {
                this.owner = stack;
                this.itemHandler = new ToolBeltInventory(stack);
                this.itemHandlerInstance = LazyOptional.of(() -> this.itemHandler);
                this.extensionSlotInstance = LazyOptional.of(() -> ToolBeltItem.this);
                this.curioItemInstance = CURIO_ITEM != null ? LazyOptional.of(() -> CURIO_ITEM.getDefaultInstance()) : LazyOptional.empty();
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ITEM_HANDLER) {
                    return this.itemHandlerInstance.cast();
                }
                if (cap == EXTENSION_SLOT_ITEM) {
                    return this.extensionSlotInstance.cast();
                }
                if (cap == CURIO_ITEM && CURIO_ITEM != null) {
                    return this.curioItemInstance.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public static int getSlotsCount(ItemStack stack) {
        int size = 2;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            size = MathHelper.func_76125_a((int)nbt.func_74762_e("Size"), (int)2, (int)9);
        }
        return size;
    }

    public static void setSlotsCount(ItemStack stack, int newSize) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            nbt.func_218657_a("Items", (INBT)new ListNBT());
        }
        nbt.func_74768_a("Size", newSize);
        stack.func_77982_d(nbt);
    }

    public static int getUpgradeXP(ItemStack stack) {
        int slots = ToolBeltItem.getSlotsCount(stack);
        if (slots >= 9) {
            return -1;
        }
        if (slots < 2) {
            return 1;
        }
        return xpCost[slots - 2];
    }

    public static ItemStack upgrade(ItemStack stack) {
        int slots = ToolBeltItem.getSlotsCount(stack);
        if (slots >= 9) {
            return stack.func_77946_l();
        }
        stack = stack.func_77946_l();
        ToolBeltItem.setSlotsCount(stack, slots + 1);
        return stack;
    }

    public ItemStack of(int upgradeLevel) {
        if (upgradeLevel < 0 || upgradeLevel >= 9) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        ToolBeltItem.setSlotsCount(stack, upgradeLevel + 2);
        return stack;
    }

    public int getLevel(ItemStack stack) {
        return ToolBeltItem.getSlotsCount(stack) - 2;
    }

    private void tickAllSlots(ItemStack source, LivingEntity player) {
        BeltExtensionContainer container = new BeltExtensionContainer(source, player);
        for (IExtensionSlot slot : container.getSlots()) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    static {
        BELT_SLOT_LIST = ImmutableSet.of((Object)RpgEquipment.BELT);
        xpCost = new int[]{3, 5, 8, 12, 15, 20, 30};
    }

    public static class BeltExtensionContainer
    implements IExtensionContainer {
        private static final ResourceLocation SLOT_TYPE = new ResourceLocation("toolbelt", "pocket");
        private final ToolBeltInventory inventory;
        private final LivingEntity owner;
        private final ImmutableList<IExtensionSlot> slots;

        public BeltExtensionContainer(ItemStack source, LivingEntity owner) {
            this.inventory = (ToolBeltInventory)source.getCapability(ITEM_HANDLER, null).orElseThrow(() -> new RuntimeException("No inventory!"));
            this.owner = owner;
            Object[] slots = new ExtensionSlotItemHandler[this.inventory.getSlots()];
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                slots[i] = new ExtensionSlotItemHandler(this, SLOT_TYPE, this.inventory, i){

                    @Override
                    public boolean canEquip(@Nonnull ItemStack stack) {
                        return inventory.canInsertItem(this.slot, stack);
                    }
                };
            }
            this.slots = ImmutableList.copyOf((Object[])slots);
        }

        @Override
        @Nonnull
        public LivingEntity getOwner() {
            return this.owner;
        }

        @Override
        @Nonnull
        public ImmutableList<IExtensionSlot> getSlots() {
            return this.slots;
        }

        @Override
        public void onContentsChanged(IExtensionSlot slot) {
        }
    }
}

