/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.sewingkit.api.ToolIngredient;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import dev.gigaherz.toolbelt.Conditions;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.belt.BeltIngredient;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.client.ClientEvents;
import dev.gigaherz.toolbelt.common.BeltContainer;
import dev.gigaherz.toolbelt.common.BeltScreen;
import dev.gigaherz.toolbelt.common.BeltSlotContainer;
import dev.gigaherz.toolbelt.common.BeltSlotScreen;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemCapability;
import dev.gigaherz.toolbelt.integration.SewingKitIntegration;
import dev.gigaherz.toolbelt.integration.SewingUpgradeRecipeBuilder;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.network.ContainerSlotsHack;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import dev.gigaherz.toolbelt.network.SwapItems;
import dev.gigaherz.toolbelt.network.SyncBeltSlotContents;
import dev.gigaherz.toolbelt.slot.BeltExtensionSlot;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="toolbelt")
public class ToolBelt {
    public static final String MODID = "toolbelt";
    @ObjectHolder(value="toolbelt:belt")
    public static ToolBeltItem BELT;
    @ObjectHolder(value="toolbelt:pouch")
    public static Item POUCH;
    @ObjectHolder(value="toolbelt:sewing_upgrade")
    public static IRecipeSerializer<?> SEWING_UGRADE_SERIALIZER;
    public static ToolBelt instance;
    public static final Logger logger;
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public ToolBelt() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::modConfig);
        modEventBus.addListener(this::imcEnqueue);
        modEventBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::anvilChange);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigData.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigData.COMMON_SPEC);
        if (ModList.get().isLoaded("sewingkit")) {
            SewingKitIntegration.init();
        }
    }

    public void gatherData(GatherDataEvent event) {
        DataGen.gatherData(event);
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        } else if (config.getSpec() == ConfigData.SERVER_SPEC) {
            ConfigData.refreshServer();
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ToolBeltItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i)).setRegistryName("belt"), (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName("pouch")});
    }

    private void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)BeltIngredient.NAME, BeltIngredient.Serializer.INSTANCE);
    }

    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)new ContainerType(BeltSlotContainer::new).setRegistryName("belt_slot_container"), (ContainerType)IForgeContainerType.create(BeltContainer::new).setRegistryName("belt_container")});
        Conditions.register();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.messageBuilder(SwapItems.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(SwapItems::encode).decoder(SwapItems::new).consumer(SwapItems::handle).add();
        channel.messageBuilder(BeltContentsChange.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(BeltContentsChange::encode).decoder(BeltContentsChange::new).consumer(BeltContentsChange::handle).add();
        channel.messageBuilder(OpenBeltSlotInventory.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(OpenBeltSlotInventory::encode).decoder(OpenBeltSlotInventory::new).consumer(OpenBeltSlotInventory::handle).add();
        channel.messageBuilder(ContainerSlotsHack.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(ContainerSlotsHack::encode).decoder(ContainerSlotsHack::new).consumer(ContainerSlotsHack::handle).add();
        channel.messageBuilder(SyncBeltSlotContents.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncBeltSlotContents::encode).decoder(SyncBeltSlotContents::new).consumer(SyncBeltSlotContents::handle).add();
        logger.debug("Final message number: " + messageNumber);
        ExtensionSlotItemCapability.register();
        BeltExtensionSlot.register();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ScreenManager.func_216911_a(BeltContainer.TYPE, BeltScreen::new);
            ScreenManager.func_216911_a(BeltSlotContainer.TYPE, BeltSlotScreen::new);
        });
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("belt").icon(ToolBelt.location("gui/empty_belt_slot_background")).size(1).build());
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientEvents.initKeybinds();
            }
        });
    }

    public void anvilChange(AnvilUpdateEvent ev) {
        if (!ConfigData.enableAnvilUpgrading) {
            return;
        }
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.func_190916_E() <= 0 || left.func_77973_b() != BELT) {
            return;
        }
        if (right.func_190916_E() <= 0 || right.func_77973_b() != POUCH) {
            return;
        }
        int cost = ToolBeltItem.getUpgradeXP(left);
        if (cost < 0) {
            ev.setCanceled(true);
            return;
        }
        ev.setCost(cost);
        ev.setMaterialCost(1);
        ev.setOutput(ToolBeltItem.upgrade(left));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        SEWING_UGRADE_SERIALIZER = null;
        logger = LogManager.getLogger((String)MODID);
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ToolBelt.location("general")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }

    public static class DataGen {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            if (event.includeClient()) {
                // empty if block
            }
            if (event.includeServer()) {
                gen.func_200390_a((IDataProvider)new Recipes(gen));
            }
        }

        private static class Recipes
        extends RecipeProvider
        implements IConditionBuilder {
            public Recipes(DataGenerator gen) {
                super(gen);
            }

            protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
                ResourceLocation beltId = Objects.requireNonNull(BELT.getRegistryName());
                ConditionalRecipe.builder().addCondition((ICondition)new Conditions.EnableNormalCrafting()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)BELT).func_200472_a("sls").func_200472_a("l l").func_200472_a("lil").func_200471_a(Character.valueOf('s'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F})).func_200471_a(Character.valueOf('l'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151116_aA})).func_200471_a(Character.valueOf('i'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j})).func_200465_a("has_leather", (ICriterionInstance)Recipes.func_200409_a((ITag)ItemTags.func_199901_a((String)"forge:leather")))).func_200464_a(arg_0)).generateAdvancement().build(consumer, beltId);
                ConditionalRecipe.builder().addCondition(this.modLoaded("sewingkit")).addCondition((ICondition)new Conditions.EnableSewingCrafting()).addRecipe(arg_0 -> ((SewingRecipeBuilder)SewingRecipeBuilder.begin((Item)BELT).withTool((Ingredient)ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.WOOD.func_200925_d())).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)SewingKitMod.LEATHER_STRIP.get()}), 2).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)SewingKitMod.LEATHER_SHEET.get()}), 3).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), 1).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F}), 2).addCriterion("has_leather", (ICriterionInstance)Recipes.func_200409_a((ITag)ItemTags.func_199901_a((String)"forge:leather")))).build(arg_0)).generateAdvancement().build(consumer, new ResourceLocation(beltId.func_110624_b(), beltId.func_110623_a() + "_via_sewing"));
                ResourceLocation pouchId = Objects.requireNonNull(POUCH.getRegistryName());
                ConditionalRecipe.builder().addCondition((ICondition)new Conditions.EnableNormalCrafting()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)POUCH).func_200472_a("sgs").func_200472_a("l l").func_200472_a("sls").func_200471_a(Character.valueOf('s'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F})).func_200471_a(Character.valueOf('l'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151116_aA})).func_200471_a(Character.valueOf('g'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k})).func_200465_a("has_leather", (ICriterionInstance)Recipes.func_200409_a((ITag)ItemTags.func_199901_a((String)"forge:leather")))).func_200464_a(arg_0)).generateAdvancement().build(consumer, pouchId);
                ConditionalRecipe.builder().addCondition(this.modLoaded("sewingkit")).addCondition((ICondition)new Conditions.EnableSewingCrafting()).addRecipe(arg_0 -> ((SewingRecipeBuilder)SewingRecipeBuilder.begin((Item)POUCH).withTool((Ingredient)ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.WOOD.func_200925_d())).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)SewingKitMod.LEATHER_STRIP.get()}), 2).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)SewingKitMod.LEATHER_SHEET.get()}), 3).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k})).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F})).addCriterion("has_leather", (ICriterionInstance)Recipes.func_200409_a((ITag)ItemTags.func_199901_a((String)"forge:leather")))).build(arg_0)).generateAdvancement().build(consumer, new ResourceLocation(pouchId.func_110624_b(), pouchId.func_110623_a() + "_via_sewing"));
                ToolIngredient[] needleTiers = new ToolIngredient[]{ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.WOOD.func_200925_d()), ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.BONE.func_200925_d()), ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.IRON.func_200925_d()), ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.IRON.func_200925_d()), ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.DIAMOND.func_200925_d()), ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.DIAMOND.func_200925_d()), ToolIngredient.fromTool((ToolType)NeedleItem.SEWING_NEEDLE, (int)Needles.NETHERITE.func_200925_d())};
                for (int i = 0; i < 7; ++i) {
                    ConditionalRecipe.builder().addCondition(this.modLoaded("sewingkit")).addCondition((ICondition)new Conditions.EnableSewingCrafting()).addRecipe(arg_0 -> ((SewingRecipeBuilder)SewingUpgradeRecipeBuilder.begin(BELT, this.compound(Pair.of((Object)"Size", (Object)IntNBT.func_229692_a_((int)(i + 3))))).withTool((Ingredient)needleTiers[i]).addMaterial((Ingredient)BeltIngredient.withLevel(i)).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{POUCH})).addMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F})).addCriterion("has_leather", (ICriterionInstance)Recipes.func_200409_a((ITag)ItemTags.func_199901_a((String)"forge:leather")))).build(arg_0)).generateAdvancement().build(consumer, new ResourceLocation(pouchId.func_110624_b(), pouchId.func_110623_a() + "_upgrade_" + (i + 1) + "_via_sewing"));
                }
            }

            public final ItemStack stack(IItemProvider item, CompoundNBT tag) {
                ItemStack stack = new ItemStack(item);
                stack.func_77982_d(tag);
                return stack;
            }

            @SafeVarargs
            public final CompoundNBT compound(Pair<String, INBT> ... entries) {
                CompoundNBT tag = new CompoundNBT();
                for (Pair<String, INBT> entry : entries) {
                    tag.func_218657_a((String)entry.getFirst(), (INBT)entry.getSecond());
                }
                return tag;
            }
        }
    }
}

