/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import dev.gigaherz.toolbelt.integration.CosmeticArmorIntegration;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.slot.BeltExtensionSlot;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.PacketDistributor;

public class BeltFinderBeltSlot
extends BeltFinder {
    public static final String FINDER_ID = "belt_slot";

    @CapabilityInject(value=BeltExtensionSlot.class)
    public static void initBaubles(Capability<?> cap) {
        BeltFinder.addFinder(new BeltFinderBeltSlot());
    }

    @Override
    protected Optional<BeltFinder.BeltGetter> getSlotFromId(PlayerEntity player, JsonElement packetData) {
        return BeltExtensionSlot.get((LivingEntity)player).resolve().map(BeltExtensionSlot::getSlots).map(slots -> (IExtensionSlot)slots.get(packetData.getAsInt())).map(slot -> new ExtensionSlotBeltGetter((LivingEntity)player, (IExtensionSlot)slot));
    }

    @Override
    public String getName() {
        return FINDER_ID;
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(LivingEntity player, boolean allowCosmetic) {
        return BeltExtensionSlot.get(player).resolve().flatMap(ext -> ext.getSlots().stream().filter(slot -> slot.getContents().func_77973_b() instanceof ToolBeltItem).map(slot -> new ExtensionSlotBeltGetter(player, (IExtensionSlot)slot)).findFirst());
    }

    private static class ExtensionSlotBeltGetter
    implements BeltFinder.BeltGetter {
        private final LivingEntity player;
        private final IExtensionSlot slot;

        private ExtensionSlotBeltGetter(LivingEntity player, IExtensionSlot slot) {
            this.player = player;
            this.slot = slot;
        }

        @Override
        public ItemStack getBelt() {
            return this.slot.getContents();
        }

        @Override
        public void setBelt(ItemStack stack) {
            this.slot.setContents(stack);
        }

        @Override
        public boolean isHidden() {
            return ModList.get().isLoaded("cosmeticarmorreworked") && this.player instanceof PlayerEntity && CosmeticArmorIntegration.isHidden((PlayerEntity)this.player, "toolbelt", "belt#0");
        }

        @Override
        public void syncToClients() {
            LivingEntity thePlayer = this.slot.getContainer().getOwner();
            if (thePlayer.field_70170_p.field_72995_K) {
                return;
            }
            BeltContentsChange message = new BeltContentsChange(thePlayer, BeltFinderBeltSlot.FINDER_ID, (JsonElement)new JsonPrimitive((Number)0), this.slot.getContents());
            ToolBelt.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> thePlayer), (Object)message);
        }
    }
}

