/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.google.gson.JsonElement;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public abstract class BeltFinder {
    private static NonNullList<BeltFinder> instances = NonNullList.func_191196_a();

    public static synchronized void addFinder(BeltFinder finder) {
        instances.add(0, (Object)finder);
    }

    public static Optional<? extends BeltGetter> findBelt(PlayerEntity player) {
        return BeltFinder.findBelt((LivingEntity)player);
    }

    public static Optional<? extends BeltGetter> findBelt(LivingEntity player) {
        return BeltFinder.findBelt(player, false);
    }

    public static Optional<? extends BeltGetter> findBelt(LivingEntity player, boolean allowCosmetic) {
        return instances.stream().map(f -> f.findStack(player, allowCosmetic)).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    public static void sendSync(PlayerEntity player) {
        BeltFinder.findBelt(player).ifPresent(BeltGetter::syncToClients);
    }

    public static void setBeltFromPacket(PlayerEntity player, String where, JsonElement slot, ItemStack stack) {
        for (BeltFinder finder : instances) {
            if (!finder.getName().equals(where)) continue;
            finder.getSlotFromId(player, slot).ifPresent(getter -> getter.setBelt(stack));
        }
    }

    public abstract String getName();

    public abstract Optional<? extends BeltGetter> findStack(LivingEntity var1, boolean var2);

    protected abstract Optional<BeltGetter> getSlotFromId(PlayerEntity var1, JsonElement var2);

    protected final Optional<? extends BeltGetter> findBeltInInventory(IItemHandler inventory, IntFunction<? extends BeltGetter> getterFactory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack inSlot = inventory.getStackInSlot(i);
            if (inSlot.func_190916_E() <= 0 || !(inSlot.func_77973_b() instanceof ToolBeltItem)) continue;
            return Optional.of(getterFactory.apply(i));
        }
        return Optional.empty();
    }

    public static interface BeltGetter {
        public ItemStack getBelt();

        default public void setBelt(ItemStack stack) {
        }

        default public boolean isHidden() {
            return false;
        }

        public void syncToClients();
    }
}

