/*
 * Decompiled with CFR 0.152.
 */
package com.minttea.minecraft.tomeofblood.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.minttea.minecraft.tomeofblood.common.items.BloodGem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BloodScroll
extends Item
implements IScribeable {
    public BloodScroll() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ArsNouveau.itemGroup));
    }

    public boolean onScribe(World world, BlockPos blockPos, PlayerEntity player, Hand hand, ItemStack itemStack) {
        ItemStack held = player.func_184586_b(hand);
        if (!(held.func_77973_b() instanceof SpellParchment) && !(held.func_77973_b() instanceof SpellBook) && held.func_77978_p() != null) {
            return false;
        }
        List parts = null;
        if (held.func_77973_b() instanceof SpellParchment) {
            parts = SpellParchment.getSpellRecipe((ItemStack)held);
        } else if (held.func_77973_b() instanceof SpellBook) {
            parts = ((SpellBook)held.func_77973_b()).getCurrentRecipe((ItemStack)held).recipe;
        }
        if (parts != null) {
            Spell spell = new Spell(parts);
            String spellTag = SpellBook.getRecipeString((CompoundNBT)held.func_77978_p(), (int)SpellBook.getMode((CompoundNBT)held.func_77978_p()));
            if (parts.size() + this.getSpell(itemStack).getSpellSize() > 30) {
                PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new StringTextComponent("Spell too complex."));
                return false;
            }
            if (parts.size() == 0) {
                itemStack.func_77978_p().func_74778_a("spell", "");
            } else if (this.getSpell(itemStack).getSpellSize() > 0) {
                if (this.addToSpell(itemStack, spellTag)) {
                    PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new StringTextComponent("Added parts to spell: " + spell.getDisplayString()));
                    return true;
                }
            } else if (this.setSpell(itemStack, spellTag)) {
                PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new StringTextComponent("Set Spell: " + spell.getDisplayString()));
                return true;
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack offHand;
        ItemStack scroll = playerIn.func_184586_b(handIn);
        if (handIn == Hand.MAIN_HAND && (offHand = playerIn.func_184586_b(Hand.OFF_HAND)).func_77973_b() instanceof BloodGem) {
            ((BloodGem)offHand.func_77973_b()).onScribe(worldIn, null, playerIn, handIn, offHand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)scroll);
    }

    public void func_77663_a(ItemStack stack, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        if (!stack.func_77942_o() || stack.func_77978_p().func_74779_i("spell").equals("")) {
            return;
        }
        Spell spell = Spell.deserialize((String)stack.func_77978_p().func_74779_i("spell"));
        tooltip.add((ITextComponent)new StringTextComponent(spell.getDisplayString()));
    }

    private Spell getSpell(ItemStack stack) {
        assert (stack.func_77978_p() != null);
        return Spell.deserialize((String)stack.func_77978_p().func_74779_i("spell"));
    }

    private boolean setSpell(ItemStack itemStack, String recipe) {
        itemStack.func_77978_p().func_74778_a("spell", recipe);
        return true;
    }

    private boolean addToSpell(ItemStack itemStack, String recipe) {
        String spellTag = itemStack.func_77978_p().func_74779_i("spell");
        spellTag = spellTag + recipe;
        itemStack.func_77978_p().func_74778_a("spell", spellTag);
        return true;
    }

    public Spell getCurrentRecipe(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return Spell.deserialize((String)stack.func_77978_p().func_74779_i("spell"));
    }
}

