/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class TileEntityWritableGrave
extends TileEntity
implements ITickableTileEntity {
    protected String ownerName = "";
    protected long deathDate;
    protected long deathMCTime = 0L;
    public int countTicks = 0;

    public TileEntityWritableGrave(TileEntityType<?> tileType) {
        super(tileType);
    }

    public abstract boolean canShowFog();

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            ++this.countTicks;
            if (this.field_145850_b.func_201670_d()) {
                if (this.canShowFog()) {
                    ModTombstone.PROXY.produceGraveSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.5);
                }
            } else if (TimeHelper.isAprilFoolsDay() && TimeHelper.atInterval(this.countTicks, 600) && Helper.RANDOM.nextFloat() < 0.3f) {
                Helper.handleAprilFoolsDayGrave(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
        if (this.field_145850_b != null) {
            this.deathMCTime = TimeHelper.worldTicks(this.field_145850_b);
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return !this.ownerName.isEmpty();
    }

    public long getDeathMCTime() {
        if (this.field_145850_b != null) {
            long worldTicks = TimeHelper.worldTicks(this.field_145850_b);
            if (this.deathMCTime > worldTicks) {
                this.deathMCTime = worldTicks;
            }
            return worldTicks - this.deathMCTime;
        }
        return 0L;
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
        this.countTicks = 0;
        if (this.field_145850_b != null) {
            this.deathMCTime = TimeHelper.worldTicks(this.field_145850_b);
        }
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return this.writeShared(compound);
    }

    protected CompoundNBT writeShared(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74772_a("deathMCTime", this.deathMCTime);
        compound.func_74768_a("countTicks", this.countTicks);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("ownerName", 8)) {
            this.ownerName = compound.func_74779_i("ownerName");
        }
        if (compound.func_150297_b("deathDate", 4)) {
            this.deathDate = compound.func_74763_f("deathDate");
        }
        if (compound.func_150297_b("deathMCTime", 4)) {
            this.deathMCTime = compound.func_74763_f("deathMCTime");
        }
        if (compound.func_150297_b("countTicks", 3)) {
            this.countTicks = compound.func_74762_e("countTicks");
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.writeShared(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    public boolean isPlayerGrave() {
        return false;
    }
}

