/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.advancement.AbstractTrigger;
import ovh.corail.tombstone.advancement.AprilFoolsDayTrigger;
import ovh.corail.tombstone.advancement.ChristmasTrigger;
import ovh.corail.tombstone.advancement.CountableTrigger;
import ovh.corail.tombstone.advancement.ITriggerable;
import ovh.corail.tombstone.advancement.SelectedPerksTrigger;
import ovh.corail.tombstone.advancement.StatelessTrigger;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.registry.ModStats;

public class ModTriggers {
    public static final ITriggerable FIRST_KNOWLEDGE = ModTriggers.register("first_knowledge");
    public static final ITriggerable MASTERY_1 = ModTriggers.register("mastery_1");
    public static final ITriggerable ENGRAVE_GRAVE_PLATE = ModTriggers.register("engrave_grave_plate");
    public static final ITriggerable ENGRAVE_DECORATIVE_GRAVE = ModTriggers.register("engrave_decorative_grave");
    public static final ITriggerable CANCEL_GHOSTLY_SHAPE = ModTriggers.register(new StatelessTrigger("cancel_ghostly_shape"){

        @Override
        public void trigger(ServerPlayerEntity player) {
            super.trigger(player);
            LangKey.MESSAGE_GHOSTLY_SHAPE_CANCELED.sendMessage((PlayerEntity)player, new Object[0]);
        }
    });
    public static final ITriggerable FIRST_GRAVE = ModTriggers.register("first_grave");
    public static final ITriggerable CHOOSE_GRAVE_TYPE = ModTriggers.register("choose_grave_type");
    public static final ITriggerable TELEPORT_TO_GRAVE = ModTriggers.register("teleport_to_grave");
    public static final ITriggerable USE_LOST_TABLET = ModTriggers.register("use_lost_tablet");
    public static final ITriggerable FIND_LOST_TABLET_VILLAGE = ModTriggers.register("find_lost_tablet_village");
    public static final ITriggerable FIND_LOST_TABLET_TREASURE = ModTriggers.register("find_lost_tablet_treasure");
    public static final ITriggerable FIND_LOST_TABLET_EXPLORATION = ModTriggers.register("find_lost_tablet_exploration");
    public static final ITriggerable USE_KNOWLEDGE = ModTriggers.register("use_knowledge");
    public static final ITriggerable USE_ASSISTANCE = ModTriggers.register("use_assistance");
    public static final ITriggerable USE_CUPIDITY = ModTriggers.register("use_cupidity");
    public static final ITriggerable USE_HOME = ModTriggers.register("use_home");
    public static final ITriggerable USE_RECALL = ModTriggers.register("use_recall");
    public static final ITriggerable KNOWLEDGE_WASTED = ModTriggers.register("knowledge_wasted");
    public static final ITriggerable EASY_OPENING = ModTriggers.register("easy_opening");
    public static final ITriggerable LOST_KNOWLEDGE = ModTriggers.register("lost_knowledge");
    public static final ITriggerable RESET_PERKS = ModTriggers.register("reset_perks");
    public static final ITriggerable IMPREGNATED_BONE_NEEDLE = ModTriggers.register("impregnated_bone_needle");
    public static final ITriggerable IMPREGNATED_RECEPTACLE = ModTriggers.register("impregnated_receptacle");
    public static final ITriggerable CHAIN_DEATH = ModTriggers.register("chain_death");
    public static final ITriggerable STRONG_OR_CAREFUL = ModTriggers.register("strong_or_careful");
    public static final ITriggerable ALMOST_UNKILLABLE = ModTriggers.register("almost_unkillable");
    public static final ITriggerable CREATE_ANCIENT_FISHING_ROD = ModTriggers.register("create_ancient_fishing_rod");
    public static final ITriggerable GRAVE_DUST_FROM_UNDEAD = ModTriggers.register("grave_dust_from_undead");
    public static final ITriggerable GRAVE_DUST_FROM_CAT_MORNING = ModTriggers.register("grave_dust_from_cat_morning");
    public static final ITriggerable GRAVE_DUST_FROM_BREAKING_TABLET = ModTriggers.register("grave_dust_from_breaking_tablet");
    public static final ITriggerable TALK_GRAVE_GUARDIAN = ModTriggers.register("talk_grave_guardian");
    public static final ITriggerable HALLOWEEN = ModTriggers.register("halloween");
    public static final ITriggerable CHRISTMAS = ModTriggers.register(new ChristmasTrigger());
    public static final ITriggerable CHRISTMAS_GIFT = ModTriggers.register("christmas_gift");
    public static final ITriggerable VILLAGER_GIFT = ModTriggers.register("villager_gift");
    public static final ITriggerable TRADE_LOLLIPOP_FOR_ESSENCE = ModTriggers.register("trade_lollipop_for_essence");
    public static final ITriggerable COLOR_SMOKE_BALL = ModTriggers.register("color_smoke_ball");
    public static final EnumMap<ItemScrollBuff.SpellBuff, ITriggerable> SPELL_BUFF = new EnumMap(Arrays.stream(ItemScrollBuff.SpellBuff.values()).collect(Collectors.toMap(Function.identity(), b -> ModTriggers.register("use_" + b.getName()))));
    public static final EnumMap<DamageType, ITriggerable> PREVENT_DEATH = new EnumMap(ItemVoodooPoppet.getValidDamageTypes().collect(Collectors.toMap(Function.identity(), d -> ModTriggers.register("prevent_death_" + d.func_176610_l()))));
    public static final ITriggerable KILL_ENOUGH_UNDEAD = ModTriggers.register("killed_enough_undead", ModStats.UNDEAD_KILLED);
    public static final ITriggerable KILL_ENOUGH_VILLAGER = ModTriggers.register("killed_enough_villager", ModStats.VILLAGER_KILLED);
    public static final ITriggerable KILL_ENOUGH_RAIDER = ModTriggers.register("killed_enough_raider", ModStats.RAIDER_KILLED);
    public static final ITriggerable EXORCISM = ModTriggers.register("exorcism", ModStats.EXORCISM);
    public static final ITriggerable ZOMBIFY = ModTriggers.register("zombify", ModStats.ZOMBIFY);
    public static final ITriggerable CONSUME_SOUL = ModTriggers.register("consume_soul", ModStats.CONSUME_SOUL);
    public static final ITriggerable CAPTURE_SOUL = ModTriggers.register("capture_soul", ModStats.CAPTURE_SOUL);
    public static final ITriggerable FREE_SOUL = ModTriggers.register("free_soul", ModStats.FREE_SOUL);
    public static final ITriggerable PRAY_ON_GRAVE = ModTriggers.register("pray_on_grave", ModStats.PRAY_ON_GRAVE);
    public static final ITriggerable PRAY_OF_PROTECTION = ModTriggers.register("pray_of_protection", ModStats.PRAY_OF_PROTECTION);
    public static final ITriggerable USE_DISENCHANTMENT = ModTriggers.register("use_disenchantment", ModStats.USE_DISENCHANTMENT);
    public static final ITriggerable USE_RECYCLING = ModTriggers.register("use_recycling", ModStats.USE_RECYCLING);
    public static final ITriggerable USE_REPAIRING = ModTriggers.register("use_repairing", ModStats.USE_REPAIRING);
    public static final ITriggerable USE_MAGIC_IMPREGNATION = ModTriggers.register("use_magic_impregnation", ModStats.USE_MAGIC_IMPREGNATION);
    public static final ITriggerable USE_VANISHING = ModTriggers.register("use_vanishing", ModStats.USE_VANISHING);
    public static final ITriggerable REVIVE_FAMILIAR = ModTriggers.register("revive_familiar", ModStats.REVIVE_FAMILIAR);
    public static final ITriggerable TOMB_RAIDING = ModTriggers.register("tomb_raiding", ModStats.TOMB_RAIDING);
    public static final ITriggerable SNEAK_GRAVE = ModTriggers.register("sneak_grave", ModStats.SNEAK_GRAVE);
    public static final ITriggerable CREATE_ANCIENT_TABLET = ModTriggers.register("create_ancient_tablet", ModStats.CREATE_ANCIENT_TABLET);
    public static final ITriggerable KILL_UNDEAD_BOSS = ModTriggers.register("kill_undead_boss", ModStats.KILL_UNDEAD_BOSS);
    public static final ITriggerable STEAL_EFFECT = ModTriggers.register("steal_effect", ModStats.STEAL_EFFECT);
    public static final ITriggerable PASS_APRIL_FOOL = ModTriggers.register(new AprilFoolsDayTrigger());
    public static final ITriggerable SELECTED_PERKS = ModTriggers.register(new SelectedPerksTrigger());
    public static final ITriggerable TRADE_GRAVE_GUARDIAN = ModTriggers.register("trade_grave_guardian", ModStats.TRADE_GRAVE_GUARDIAN);
    public static final CountableTrigger TRADE_LOLLIPOP = ModTriggers.register(new CountableTrigger("trade_lollipop", ModStats.TRADED_LOLLIPOP));

    private static ITriggerable register(String name) {
        return ModTriggers.register(new StatelessTrigger(name));
    }

    private static ITriggerable register(String name, ResourceLocation stat) {
        return ModTriggers.register(new CountableTrigger(name, stat));
    }

    private static <T extends AbstractTrigger<?>> T register(T trigger) {
        return (T)((AbstractTrigger)CriteriaTriggers.func_192118_a(trigger));
    }
}

