/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public class PerkJailer
extends Perk {
    public PerkJailer() {
        super("jailer", new ResourceLocation("tombstone", "textures/item/grave_key.png"));
    }

    @Override
    public int getLevelMax() {
        return 5 - (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() / 20;
    }

    @Override
    public boolean isDisabled(@Nullable PlayerEntity player) {
        return (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() == -1 || (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() == 100;
    }

    @Override
    public ITextComponent getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return new StringTextComponent("+" + level * 20 + "% ").func_230529_a_(this.getDescription());
        }
        if (level == actualLevel + 1) {
            return new StringTextComponent("+" + level * 20 + "%");
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public ITextComponent getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getText((Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() + levelWithBonus * 20);
    }
}

