/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

public class PerkBoneCollector
extends Perk {
    public PerkBoneCollector() {
        super("bone_collector", new ResourceLocation("minecraft", "textures/item/bone.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public ITextComponent getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return new StringTextComponent("+" + level * 30 + "% ").func_230529_a_(this.getDescription());
        }
        if (level == actualLevel + 1) {
            return new StringTextComponent("+" + level * 30 + "%");
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        int bonus;
        switch (TimeHelper.getSpecialEvent()) {
            case APRIL_FOOLS: 
            case CHRISTMAS: {
                bonus = this.getLevelMax();
                break;
            }
            case HALLOWEEN: {
                bonus = 3;
                break;
            }
            default: {
                bonus = 0;
            }
        }
        return bonus + (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModItems.christmas_hat ? 2 : 0);
    }
}

