/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
abstract class CustomParticle
extends Particle {
    protected static final double PI = Math.PI;
    protected static final double TWO_PI = Math.PI * 2;
    protected final float DEFAULT_ROLL = 0.31415927f;
    private float rollIncrement = 0.0f;
    private float quadSize = 0.2f;
    private boolean isSolid = false;
    private Supplier<Float> alphaSupplier = null;
    private Runnable colorSetter = null;
    private static final IParticleRenderType CUSTOM_SOLID = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }

        public void func_217599_a(Tessellator tessellator) {
        }
    };
    private static final IParticleRenderType CUSTOM_ALPHA = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder builder, TextureManager textureManager) {
            ALPHA_STATE.run();
        }

        public void func_217599_a(Tessellator tessellator) {
        }
    };
    protected static final Runnable ALPHA_STATE = () -> {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
    };

    protected CustomParticle(ClientWorld level, Vector3d vec) {
        this(level, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    protected CustomParticle(ClientWorld level, double x, double y, double z) {
        this(level, x, y, z, 0.0, 0.0, 0.0);
    }

    protected CustomParticle(ClientWorld level, double x, double y, double z, double mX, double mY, double mZ) {
        super(level, x, y, z);
        this.field_187129_i = mX;
        this.field_187130_j = mY;
        this.field_187131_k = mZ;
        this.field_190017_n = false;
    }

    protected boolean requireRemoval() {
        return this.field_70546_d >= this.field_70547_e;
    }

    public void func_189213_a() {
        if (this.requireRemoval()) {
            this.func_187112_i();
        } else {
            ++this.field_70546_d;
            this.updateLastPos();
            this.updatePosition();
            this.update();
        }
    }

    public Particle func_70541_f(float scale) {
        this.quadSize *= scale;
        this.func_187115_a(this.quadSize, this.quadSize);
        return this;
    }

    protected abstract ResourceLocation getTexture();

    protected void updatePosition() {
        if (this.field_187129_i != 0.0 || this.field_187130_j != 0.0 || this.field_187131_k != 0.0) {
            this.func_187108_a(this.func_187116_l().func_72317_d(this.field_187129_i, this.field_187130_j, this.field_187131_k));
            this.func_187118_j();
        }
    }

    protected void update() {
        if (this.rollIncrement > 0.0f) {
            this.field_190015_G = this.field_190014_F;
            this.field_190014_F += this.rollIncrement;
        }
        if (this.colorSetter != null) {
            this.colorSetter.run();
        }
        if (this.alphaSupplier != null) {
            this.field_82339_as = this.alphaSupplier.get().floatValue();
        }
    }

    protected void updateLastPos() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public CustomParticle withColor(int color) {
        float[] colors = Helper.getRGBColor3F(color);
        this.func_70538_b(colors[0], colors[1], colors[2]);
        return this;
    }

    public CustomParticle withColor(Supplier<Float> func) {
        this.colorSetter = () -> {
            float color = ((Float)func.get()).floatValue();
            this.func_70538_b(color, color, color);
        };
        return this;
    }

    public CustomParticle withColor(Function<Float, Float> funcR, Function<Float, Float> funcG, Function<Float, Float> funcB) {
        this.colorSetter = () -> this.func_70538_b(((Float)funcR.apply(Float.valueOf(this.field_70552_h))).floatValue(), ((Float)funcG.apply(Float.valueOf(this.field_70553_i))).floatValue(), ((Float)funcB.apply(Float.valueOf(this.field_70551_j))).floatValue());
        return this;
    }

    public void setSolid(boolean isSolid) {
        this.isSolid = isSolid;
    }

    public void setRolling(float rollIncrement) {
        this.setRolling((float)(Math.PI * 2 * (double)Helper.RANDOM.nextFloat()), rollIncrement);
    }

    public void setRolling(float rollStart, float rollIncrement) {
        if (rollIncrement != 0.0f) {
            this.field_190014_F = rollStart;
            this.rollIncrement = rollIncrement;
            this.field_190015_G = this.field_190014_F - this.rollIncrement;
        } else {
            this.field_190014_F = this.field_190015_G = rollStart;
            this.rollIncrement = 0.0f;
        }
    }

    public void func_82338_g(float alpha) {
        this.alphaSupplier = null;
        this.field_82339_as = alpha;
    }

    public void setAlpha(Supplier<Float> alphaSupplier) {
        this.alphaSupplier = alphaSupplier;
        this.field_82339_as = alphaSupplier.get().floatValue();
    }

    protected float getU0() {
        return 0.0f;
    }

    protected float getU1() {
        return 1.0f;
    }

    protected float getV0() {
        return 0.0f;
    }

    protected float getV1() {
        return 1.0f;
    }

    public IParticleRenderType func_217558_b() {
        return this.isSolid ? CUSTOM_SOLID : CUSTOM_ALPHA;
    }

    protected int func_189214_a(float partialTick) {
        return 0xF000F0;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        this.beginRender();
        Vector3d vecFromCamera = new Vector3d(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f), MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g), MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h)).func_178788_d(renderInfo.func_216785_c());
        int light = this.func_189214_a(partialTicks);
        Quaternion rollTransform = this.getRollQuaternion(renderInfo, partialTicks);
        Vector3f[] vecFaceQuad = this.getFaceQuad();
        Arrays.stream(vecFaceQuad).forEach(v -> {
            v.func_214905_a(rollTransform);
            v.func_195898_a(this.quadSize);
            v.func_195904_b((float)vecFromCamera.field_72450_a, (float)vecFromCamera.field_72448_b, (float)vecFromCamera.field_72449_c);
        });
        this.addQuad(buffer, vecFaceQuad, light);
        this.endRender();
    }

    protected void beginRender() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture());
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected void endRender() {
        Tessellator.func_178181_a().func_78381_a();
    }

    protected Quaternion getRollQuaternion(ActiveRenderInfo renderInfo, float partialTicks) {
        if (this.field_190014_F == 0.0f) {
            return renderInfo.func_227995_f_();
        }
        Quaternion rollTransform = new Quaternion(renderInfo.func_227995_f_());
        rollTransform.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F)));
        return rollTransform;
    }

    protected Vector3f[] getFaceQuad() {
        return new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
    }

    protected void addQuad(IVertexBuilder buffer, Vector3f[] points, int light) {
        buffer.func_225582_a_((double)points[0].func_195899_a(), (double)points[0].func_195900_b(), (double)points[0].func_195902_c()).func_225583_a_(this.getU1(), this.getV1()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(light).func_181675_d();
        buffer.func_225582_a_((double)points[1].func_195899_a(), (double)points[1].func_195900_b(), (double)points[1].func_195902_c()).func_225583_a_(this.getU1(), this.getV0()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(light).func_181675_d();
        buffer.func_225582_a_((double)points[2].func_195899_a(), (double)points[2].func_195900_b(), (double)points[2].func_195902_c()).func_225583_a_(this.getU0(), this.getV0()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(light).func_181675_d();
        buffer.func_225582_a_((double)points[3].func_195899_a(), (double)points[3].func_195900_b(), (double)points[3].func_195902_c()).func_225583_a_(this.getU0(), this.getV1()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(light).func_181675_d();
    }
}

