/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;

public class UpdateClientMessage {
    private final BlockPos spawnPos;
    private final int range;
    private final TimeHelper.SpecialEvent specialEvent;

    public UpdateClientMessage(BlockPos spawnPos, int range, TimeHelper.SpecialEvent specialEvent) {
        this.spawnPos = spawnPos;
        this.range = range;
        this.specialEvent = specialEvent;
    }

    static UpdateClientMessage fromBytes(PacketBuffer buf) {
        return new UpdateClientMessage(BlockPos.func_218283_e((long)buf.readLong()), buf.readInt(), TimeHelper.SpecialEvent.byId(buf.readShort()));
    }

    static void toBytes(UpdateClientMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.spawnPos.func_218275_a());
        buf.writeInt(msg.range);
        buf.writeShort(msg.specialEvent.ordinal());
    }

    public static class Handler {
        static void handle(UpdateClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    SpawnProtectionHandler.getInstance().setSpawnProtection(message.spawnPos, message.range);
                    TimeHelper.setSpecialEvent(message.specialEvent);
                    PacketHandler.sendToServer(new UpdateServerMessage(ModTombstone.PROXY.initPlayerPreference(), true));
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

