/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final int LIMIT_VALID = DamageType.COLD.ordinal() + 1;
    private static final String POPPET_PROT_PREFIX = "poppet_prot_";

    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder().func_234689_a_(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.func_230531_f_()).func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        List<DamageType> damageTypes = ItemVoodooPoppet.getValidDamageTypes().filter(d -> this.hasProtection(stack, (DamageType)((Object)d))).collect(Collectors.toList());
        damageTypes.forEach(d -> tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + "." + d.func_176610_l()).func_240703_c_(StyleType.TOOLTIP_ITEM)));
        boolean enchanted = this.isEnchanted(stack);
        this.addItemUse(tooltip, enchanted ? "3" : (damageTypes.isEmpty() ? "1" : "2"), new Object[0]);
        if (enchanted) {
            tooltip.add((ITextComponent)ModPerks.voodoo_poppet.getSpecialInfo(EntityHelper.getPerkLevelWithBonus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModPerks.voodoo_poppet)).func_230531_f_().func_230530_a_(StyleType.INFO));
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_FAILED.getText(new Object[0]);
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (!this.isEnchanted(stack) && ItemVoodooPoppet.getValidDamageTypes().anyMatch(p -> this.hasProtection(stack, (DamageType)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    public ItemStack createWithRandomProtections(int count) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(new ItemStack((IItemProvider)this), count), "enchant", true);
    }

    public static Stream<DamageType> getValidDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, DamageType.COLD.ordinal() + 1);
    }

    public Stream<DamageType> getCraftableDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, DamageType.DARKNESS.ordinal() + 1);
    }

    public ItemStack addProtection(ItemStack stack, DamageType damageType) {
        if (stack.func_77973_b() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, damageType)) {
            NBTStackHelper.setBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal(), true);
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, DamageType damageType) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    public boolean preventDeath(ServerPlayerEntity player, DamageSource source) {
        DamageType damageType = this.getPoppetProtection(source);
        if (damageType == null) {
            return false;
        }
        int chance = 50 + EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.voodoo_poppet) * 10;
        ItemStack voodooPoppet = InventoryHelper.findFirstInInventory((PlayerEntity)player, p -> this.canPreventDeath((ItemStack)p, damageType));
        if (voodooPoppet.func_190926_b()) {
            return false;
        }
        if (Helper.RANDOM.nextInt(100) >= chance) {
            LangKey.MESSAGE_VOODOO_POPPET_PREVENT_DEATH_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        NBTStackHelper.removeKeyName(voodooPoppet, POPPET_PROT_PREFIX + damageType.ordinal());
        if (ItemVoodooPoppet.getValidDamageTypes().noneMatch(d -> this.hasProtection(voodooPoppet, (DamageType)((Object)d)))) {
            voodooPoppet.func_190918_g(1);
        }
        int duration = TimeHelper.tickFromSecond((Integer)ConfigTombstone.decorative_grave.durationVoodooPoppetEffects.get());
        LangKey.sendMessage((ITextComponent)new TranslationTextComponent("message.prevent_death." + damageType.func_176610_l()), (PlayerEntity)player, StyleType.MESSAGE_SPECIAL);
        ModTriggers.PREVENT_DEATH.get((Object)damageType).trigger(player);
        switch (damageType) {
            case SUFFOCATION: {
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.aquatic_life, duration);
                break;
            }
            case BURN: {
                player.func_70066_B();
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76426_n, duration);
                break;
            }
            case LIGHTNING: {
                player.func_70066_B();
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.lightning_resistance, duration);
                break;
            }
            case FALL: {
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.feather_fall, duration);
                break;
            }
            case DARKNESS: {
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76443_y, duration);
                EffectHelper.clearBadEffects((LivingEntity)player);
                break;
            }
            case COLD: {
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76422_e, duration);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76424_c, duration);
                break;
            }
        }
        return true;
    }

    public boolean canPreventDeath(ItemStack stack, DamageType damageType) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    @Nullable
    public DamageType getPoppetProtection(DamageSource srcDmg) {
        DamageType damageType = DamageType.of(srcDmg);
        return ItemVoodooPoppet.getValidDamageTypes().filter(d -> d == damageType).findFirst().orElse(null);
    }

    private ItemStack setRandomProtections(ItemStack stack, int count) {
        List<DamageType> damages = ItemVoodooPoppet.getValidDamageTypes().collect(Collectors.toList());
        if (count < LIMIT_VALID) {
            IntStream.range(0, LIMIT_VALID - count).forEach(i -> {
                DamageType cfr_ignored_0 = (DamageType)((Object)((Object)damages.remove(Helper.RANDOM.nextInt(damages.size()))));
            });
        }
        damages.forEach(d -> this.addProtection(stack, (DamageType)((Object)d)));
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(stack, Helper.RANDOM.nextInt(5) + 1), "enchant", true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

