/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfHome
extends ItemTablet {
    public ItemTabletOfHome() {
        super("tablet_of_home", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfHome.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        if (this.isAncient(stack)) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
        }
        this.addItemUse(tooltip, !this.isEnchanted(stack) ? "1" : "2", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack) {
        MinecraftServer server = player.func_184102_h();
        assert (server != null);
        Pair<ServerWorld, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(server, player);
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !((ServerWorld)respawnPoint.getLeft()).func_234923_W_().equals(world.func_234923_W_())) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        Location location = new SpawnHelper((ServerWorld)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
        if (location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        CallbackHandler.addCallback(1, () -> {
            boolean isAncient = this.isAncient(stack);
            List additionalTeleport = isAncient ? world.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0), e -> e.func_70089_S() && e.func_184222_aU() && !e.func_175149_v()) : Collections.emptyList();
            ServerPlayerEntity newPlayer = Helper.teleportEntity(player, location, (ServerWorld)respawnPoint.getLeft());
            if (isAncient) {
                Location target = new Location((Entity)newPlayer);
                additionalTeleport.forEach(entity -> Helper.teleportEntity(entity, target, (ServerWorld)respawnPoint.getLeft()));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newPlayer, new Object[0]);
            ModTriggers.USE_HOME.trigger(player);
        });
        return true;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        if (!this.isAncient(stack) && soulStrenght > 1) {
            NBTStackHelper.setBoolean(stack, "ancient", true);
            ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
            return 2;
        }
        return 1;
    }

    @Override
    public CastingType getCastingType(ItemStack stack) {
        return this.isAncient(stack) ? CastingType.AREA_TELEPORT : CastingType.SIMPLE_TELEPORT;
    }
}

