/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll
implements IDelayedNBTLoot {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge", () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfKnowledge.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        if (!this.isEnchanted(stack)) {
            this.addItemDesc(tooltip, "1", SharedConfigTombstone.general.scrollOfKnowledgeLoss.get());
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            this.addItemDesc(tooltip, "2", new Object[0]);
            this.addInfo(tooltip, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
            this.addItemUse(tooltip, "2", new Object[0]);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getText(new Object[0]);
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        float knowledgeLoss = (float)(100 - (Integer)SharedConfigTombstone.general.scrollOfKnowledgeLoss.get()) / 100.0f;
        boolean valid = this.setStoredXp(stack, (int)((float)EntityHelper.getPlayerTotalXp((PlayerEntity)player) * knowledgeLoss));
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
            player.field_71144_ck = -1;
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack) {
        int i;
        int storedXp = this.getStoredXp(stack);
        if (storedXp > (i = Integer.MAX_VALUE - player.field_71067_cb)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        EntityHelper.setPlayerXp((PlayerEntity)player, EntityHelper.getPlayerTotalXp((PlayerEntity)player) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
        ModTriggers.USE_KNOWLEDGE.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        return Math.max(NBTStackHelper.getInteger(stack, "stored_xp"), 0);
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.func_77973_b() == this && xp > 0) {
            NBTStackHelper.setInteger(stack, "stored_xp", xp);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        tag.func_74768_a("stored_xp", Helper.RANDOM.nextInt((Integer)ConfigTombstone.loot.maxXpLostPage.get()) + 1);
        return stack;
    }

    public ItemStack createWithXp(int xp) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_196082_o().func_74768_a("stored_xp", xp);
        return stack;
    }
}

