/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfMagicImpregnation
extends ItemBook {
    public ItemBookOfMagicImpregnation() {
        super("book_of_magic_impregnation", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfMagicImpregnation.get());
        this.withDefaultInfo().withBetaInfo();
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        int consumed;
        ItemStack offhand;
        if (stack.func_77973_b() != this || (offhand = player.func_184592_cb()).func_190926_b()) {
            return 0;
        }
        if (offhand.func_77973_b() == Items.field_151032_g) {
            consumed = soulStrength;
            player.func_184201_a(EquipmentSlotType.OFFHAND, soulStrength == 1 ? EffectHelper.createRandomArrows(offhand.func_190916_E()) : EffectHelper.createCursedArrows(offhand.func_190916_E()));
        } else {
            Map<Enchantment, Integer> enchantments = EnchantHelper.getEnchantments(offhand);
            if (enchantments.size() == 0) {
                int enchantability = offhand.func_77973_b().getItemEnchantability(offhand);
                if (!offhand.func_77956_u() || enchantability == 0) {
                    return 0;
                }
                consumed = soulStrength;
                enchantments = this.getRandomEnchantments(enchantability + Helper.RANDOM.nextInt(soulStrength * 30), offhand, soulStrength > 1);
                if (offhand.func_77973_b() == Items.field_151122_aG) {
                    offhand = new ItemStack((IItemProvider)Items.field_151134_bR);
                    player.func_184201_a(EquipmentSlotType.OFFHAND, offhand);
                }
            } else {
                List upgradables = enchantments.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).func_77325_b() > (Integer)e.getValue()).collect(Collectors.toList());
                if (upgradables.size() == 0) {
                    return 0;
                }
                if (soulStrength == 1 || upgradables.size() == 1) {
                    Map.Entry entry2 = (Map.Entry)upgradables.get(Helper.RANDOM.nextInt(upgradables.size()));
                    consumed = 1;
                    enchantments.put((Enchantment)entry2.getKey(), (Integer)entry2.getValue() + 1);
                } else {
                    consumed = 2;
                    enchantments.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).func_77325_b() > (Integer)e.getValue()).forEach(entry -> entry.setValue((Integer)entry.getValue() + 1));
                }
            }
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)offhand);
        }
        stack.func_190918_g(1);
        ModTriggers.USE_MAGIC_IMPREGNATION.trigger(player);
        return consumed;
    }

    private Map<Enchantment, Integer> getRandomEnchantments(int roll, ItemStack stack, boolean hasStrongSoul) {
        ArrayList<EnchantmentData> availableEnchantments = new ArrayList<EnchantmentData>();
        boolean isBook = stack.func_77973_b() == Items.field_151122_aG;
        block0: for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            int maxLevel;
            if (enchantment.func_190936_d() || !hasStrongSoul && !enchantment.canApplyAtEnchantingTable(stack) && (!isBook || !enchantment.isAllowedOnBooks())) continue;
            for (int i = maxLevel = enchantment.func_77325_b(); i >= enchantment.func_77319_d(); --i) {
                if (roll < enchantment.func_77321_a(i) || i != maxLevel && roll > enchantment.func_223551_b(i)) continue;
                availableEnchantments.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        HashMap<Enchantment, Integer> res = new HashMap<Enchantment, Integer>();
        if (!availableEnchantments.isEmpty()) {
            int max = hasStrongSoul ? 6 : 3;
            for (int i = 0; i < max && !availableEnchantments.isEmpty(); ++i) {
                EnchantmentData ench = (EnchantmentData)WeightedRandom.func_76271_a((Random)Helper.RANDOM, availableEnchantments);
                if (ench == null) continue;
                res.put(ench.field_76302_b, ench.field_76303_c);
                availableEnchantments.removeIf(e -> !e.field_76302_b.func_191560_c(ench.field_76302_b));
            }
        }
        return res;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_MAGIC_IMPREGNATION_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        ItemStack offhand = player.func_184592_cb();
        if (!EnchantHelper.getEnchantments(offhand).isEmpty()) {
            return LangKey.MESSAGE_MAGIC_IMPREGNATION_MAX.getText(new Object[0]);
        }
        return LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]);
    }
}

