/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemBook {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
        this.withDefaultInfo();
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        ResourceLocation registryName;
        if (stack.func_77973_b() != this) {
            return 0;
        }
        ItemStack offhand = player.func_184592_cb();
        if (offhand.func_190926_b() || offhand.func_77973_b() == Items.field_151134_bR || !offhand.func_77948_v()) {
            return 0;
        }
        if (SupportMods.TETRA.isLoaded() && (registryName = offhand.func_77973_b().getRegistryName()) != null && registryName.func_110624_b().equals(SupportMods.TETRA.func_176610_l()) && registryName.func_110623_a().startsWith("modular_")) {
            return 0;
        }
        Map<Enchantment, Integer> list = EnchantHelper.getEnchantments(offhand);
        if (list.size() == 0) {
            return 0;
        }
        Iterator<Map.Entry<Enchantment, Integer>> it = list.entrySet().iterator();
        stack.func_190918_g(1);
        int enchantMax = EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.disenchanter) + 1;
        int enchantCount = 0;
        while (enchantCount < enchantMax && it.hasNext()) {
            Map.Entry<Enchantment, Integer> entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            map.put(entry.getKey(), entry.getValue());
            EnchantmentHelper.func_82782_a(map, (ItemStack)book);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)book);
            it.remove();
            ++enchantCount;
        }
        int left = list.size();
        if (left == 0) {
            if (offhand.func_82837_s()) {
                offhand.func_82841_c(1);
            } else {
                offhand.func_196083_e("RepairCost");
            }
        }
        EnchantmentHelper.func_82782_a(list, (ItemStack)offhand);
        ModTriggers.USE_DISENCHANTMENT.trigger(player);
        return 1;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        int leftEnchant = NBTStackHelper.getListOrCreate(player.func_184592_cb().func_196082_o(), "Enchantments").size();
        if (leftEnchant == 0) {
            return LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]);
        }
        return LangKey.MESSAGE_DISENCHANTMENT_PARTIAL_SUCCESS.getText(leftEnchant);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]);
    }
}

