/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.ProtectedEntityProvider;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.IChanneling;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.PrayerMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer,
IChanneling {
    private Multimap<Attribute, AttributeModifier> attributes;

    public ItemAnkhOfPray() {
        super("ankh_of_pray", ItemAnkhOfPray.getBuilder().func_200915_b(30).func_234689_a_());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        PlayerEntity player = ModTombstone.PROXY.getClientPlayer();
        if (player != null) {
            if (!this.func_77636_d(stack)) {
                int cd = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
                if (cd > 0) {
                    this.addItemUse(tooltip, "1", new StringTextComponent("[" + TimeHelper.getTimeString(cd) + "]").func_240703_c_(StyleType.TOOLTIP_DESC));
                }
            } else {
                this.addItemUse(tooltip, "2", new Object[0]);
            }
            if (CooldownHandler.INSTANCE.getCooldown(player, CooldownType.RESET_PERKS) <= 0) {
                this.addItemUse(tooltip, "3", new Object[0]);
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        return ctx.func_195999_j() != null ? this.func_77659_a(ctx.func_195991_k(), ctx.func_195999_j(), ctx.func_221531_n()).func_188397_a() : ActionResultType.FAIL;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (EntityHelper.isValidPlayer(player) && hand == Hand.MAIN_HAND && player.func_184614_ca().func_77973_b() == this && EntityHelper.noGlobalItemCooldown(player, this) && CooldownHandler.INSTANCE.noCooldown(player, CooldownType.NEXT_PRAY) && !EffectHelper.isPotionActive(target, ModEffects.prayer)) {
            if (target instanceof ZombieVillagerEntity) {
                return this.handleInteractEntity(player, target, 3, null);
            }
            int alignment = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
            if (alignment < 0) {
                if (target instanceof VillagerEntity) {
                    return this.handleInteractEntity(player, target, 2, target.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : null);
                }
            } else if (alignment > 0) {
                TameableType tameableType;
                if (alignment > 1 && (tameableType = TameableType.getType((Entity)target)) != null) {
                    return this.handleInteractEntity(player, target, 0, tameableType.getOwnerId((Entity)target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null);
                }
                return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(protCap -> this.handleInteractEntity(player, target, 1, protCap.isActive() ? LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED : null)).orElse(ActionResultType.SUCCESS);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType handleInteractEntity(PlayerEntity player, LivingEntity target, int prayType, @Nullable LangKey failKey) {
        if (failKey != null) {
            if (!player.field_70170_p.func_201670_d()) {
                failKey.sendMessage(player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
        } else {
            player.func_184598_c(Hand.MAIN_HAND);
            if (!player.field_70170_p.func_201670_d()) {
                EntityHelper.getPersistentTag(player).func_74768_a("prayer", target.func_145782_y());
                target.getPersistentData().func_186854_a("prayer", player.func_110124_au());
                target.getPersistentData().func_74777_a("pray_type", (short)prayType);
                int duration = 200;
                EffectHelper.addEffect(target, ModEffects.prayer, 200, 1, new boolean[0]);
                PacketHandler.sendToAllTrackingPlayersAndSelf(new PrayerMessage(target.func_145782_y(), player.func_110124_au(), prayType, 200), target);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77615_a(ItemStack stack, World level, LivingEntity entity, int remainingTicks) {
        if (!level.func_201670_d() && EntityHelper.isValidServerPlayer((Entity)entity)) {
            this.onStopCasting((ServerPlayerEntity)entity);
        }
    }

    private void onStopCasting(ServerPlayerEntity player) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        persistentTag.func_82580_o("prayer");
        persistentTag.func_82580_o("pray_type");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (!EntityHelper.isValidPlayer(player)) {
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        if (hand != Hand.MAIN_HAND || heldStack.func_77973_b() != this) {
            return ActionResult.func_226250_c_((Object)heldStack);
        }
        if (EntityHelper.hasGlobalItemCooldown(player, this) || CooldownHandler.INSTANCE.hasCooldown(player, CooldownType.NEXT_PRAY)) {
            return ActionResult.func_226249_b_((Object)heldStack);
        }
        ItemStack offhand = player.func_184592_cb();
        if (ModItems.familiar_receptacle.containSoul(offhand) && ModItems.familiar_receptacle.getDurabilityForDisplay(offhand) != 0.0) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.field_70170_p.func_201670_d()) {
                LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendMessage(player, StyleType.COLOR_OFF, new Object[0]);
            }
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)heldStack);
    }

    public ItemStack func_77654_b(ItemStack stack, @Nullable World world, LivingEntity entity) {
        ServerPlayerEntity player;
        if (stack.func_77973_b() == this && EntityHelper.isValidServerPlayer((Entity)entity) && EntityHelper.noGlobalItemCooldown((PlayerEntity)(player = (ServerPlayerEntity)entity), this) && CooldownHandler.INSTANCE.noCooldown((PlayerEntity)player, CooldownType.NEXT_PRAY)) {
            CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
            if (persistentTag.func_150297_b("prayer", 3)) {
                LivingEntity living;
                Entity target = player.field_70170_p.func_73045_a(persistentTag.func_74762_e("prayer"));
                this.onStopCasting(player);
                if (target instanceof LivingEntity && EffectHelper.isPotionActive(living = (LivingEntity)target, ModEffects.prayer)) {
                    living.func_195063_d(ModEffects.prayer);
                    int alignment = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                    if (PrayerHelper.exorcism(player, living, alignment) || PrayerHelper.zombify(player, living, alignment) || PrayerHelper.empathy(player, living, alignment) || PrayerHelper.protection(player, living, alignment)) {
                        return stack;
                    }
                }
                return stack;
            }
            PrayerHelper.onGrave(player, player.func_233580_cy_());
            EntityHelper.setGlobalItemCooldown((PlayerEntity)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        this.onChanneling(stack, entity, timeLeft);
    }

    @Override
    public CastingType getCastingType(ItemStack stack) {
        return CastingType.PRAY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityHelper.hasGlobalItemCooldown((PlayerEntity)player, stack)) {
            return false;
        }
        int cooldownToPray = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.NEXT_PRAY);
        if (cooldownToPray > 0) {
            int maxTime = CooldownType.NEXT_PRAY.getMaxCooldown((PlayerEntity)player);
            int elapsedTime = maxTime - cooldownToPray;
            CooldownTracker cd = player.func_184811_cZ();
            cd.field_185148_b -= elapsedTime;
            cd.func_185145_a((Item)this, maxTime);
            cd.field_185148_b += elapsedTime;
            return false;
        }
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return stack.func_77973_b() == this;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return stack.func_77973_b() == this;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int func_77619_b() {
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (slot == EquipmentSlotType.MAINHAND) {
            if (this.attributes != null) {
                return this.attributes;
            }
            if (ForgeMod.REACH_DISTANCE.isPresent()) {
                this.attributes = ImmutableMultimap.builder().put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(UUID.fromString("a336c4e4-a0c4-4da9-ba45-4b7de7eb449d"), "Ankh range bonus", 10.0, AttributeModifier.Operation.ADDITION)).build();
                return this.attributes;
            }
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> {
            boolean hasReset = cap.resetPerks(player);
            if (hasReset) {
                ModTriggers.RESET_PERKS.trigger(player);
                return 1;
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        int cd;
        if (!player.field_70170_p.func_201670_d() && (cd = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.RESET_PERKS)) > 0) {
            int min = cd / 1200;
            if (min > 0) {
                cd -= min * 1200;
            }
            return LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getText(min, cd / 20);
        }
        return LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]);
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

