/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.perk.PerkRegistry;

public class NBTStackHelper {
    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        stack.func_196082_o().func_74778_a(keyName, keyValue);
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        return NBTStackHelper.getString(stack.func_77978_p(), keyName);
    }

    public static String getString(@Nullable CompoundNBT tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.func_150297_b(keyName, 8)).map(t -> t.func_74779_i(keyName)).orElse("");
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        stack.func_196082_o().func_74757_a(keyName, keyValue);
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        return NBTStackHelper.getBoolean(stack.func_77978_p(), keyName);
    }

    public static boolean getBoolean(@Nullable CompoundNBT tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.func_150297_b(keyName, 1)).map(t -> t.func_74767_n(keyName)).orElse(false);
    }

    public static ItemStack setShort(ItemStack stack, String keyName, short keyValue) {
        stack.func_196082_o().func_74777_a(keyName, keyValue);
        return stack;
    }

    public static short getShort(ItemStack stack, String keyName) {
        return NBTStackHelper.getShort(stack, keyName, (short)Short.MIN_VALUE);
    }

    public static short getShort(ItemStack stack, String keyName, short fallback) {
        return Optional.ofNullable(stack.func_77978_p()).filter(tag -> tag.func_150297_b(keyName, 2)).map(tag -> tag.func_74765_d(keyName)).orElse(fallback);
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        stack.func_196082_o().func_74768_a(keyName, keyValue);
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        return NBTStackHelper.getInteger(stack, keyName, Integer.MIN_VALUE);
    }

    public static int getInteger(ItemStack stack, String keyName, int fallback) {
        return Optional.ofNullable(stack.func_77978_p()).filter(tag -> tag.func_150297_b(keyName, 3)).map(tag -> tag.func_74762_e(keyName)).orElse(fallback);
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        stack.func_196082_o().func_74772_a(keyName, keyValue);
        return stack;
    }

    @Deprecated
    public static long getLong(ItemStack stack, String keyName) {
        return NBTStackHelper.getLong(stack, keyName, Long.MIN_VALUE);
    }

    public static long getLong(ItemStack stack, String keyName, long fallback) {
        return Optional.ofNullable(stack.func_77978_p()).filter(tag -> tag.func_150297_b(keyName, 4)).map(tag -> tag.func_74763_f(keyName)).orElse(fallback);
    }

    public static ItemStack setUUID(ItemStack stack, String keyName, @Nullable UUID uuid) {
        NBTStackHelper.setUUID(stack.func_196082_o(), keyName, uuid);
        return stack;
    }

    public static void setUUID(CompoundNBT tag, String keyName, @Nullable UUID uuid) {
        if (uuid != null) {
            tag.func_186854_a(keyName, uuid);
        }
    }

    @Nullable
    public static UUID getUUID(ItemStack stack, String keyName, @Nullable UUID fallback) {
        return Optional.ofNullable(stack.func_77978_p()).map(t -> NBTStackHelper.getUUID(t, keyName, fallback)).orElse(fallback);
    }

    @Nullable
    public static UUID getUUID(CompoundNBT tag, String keyName, @Nullable UUID fallback) {
        return tag.func_150297_b(keyName, 11) ? tag.func_186857_a(keyName) : fallback;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setBlockPos(stack.func_196082_o(), keyName, keyValue);
        return stack;
    }

    public static void setBlockPos(CompoundNBT tag, String keyName, BlockPos keyValue) {
        tag.func_74768_a(keyName + "X", keyValue.func_177958_n());
        tag.func_74768_a(keyName + "Y", keyValue.func_177956_o());
        tag.func_74768_a(keyName + "Z", keyValue.func_177952_p());
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        return NBTStackHelper.getBlockPos(stack.func_77978_p(), keyName);
    }

    public static BlockPos getBlockPos(@Nullable CompoundNBT tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.func_150297_b(keyName + "X", 3) && t.func_150297_b(keyName + "Y", 3) && t.func_150297_b(keyName + "Z", 3)).map(t -> new BlockPos(t.func_74762_e(keyName + "X"), t.func_74762_e(keyName + "Y"), t.func_74762_e(keyName + "Z"))).orElse(Location.ORIGIN_POS);
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location location) {
        NBTStackHelper.setLocation(stack.func_196082_o(), keyName, location);
        return stack;
    }

    public static CompoundNBT setLocation(CompoundNBT tag, String keyName, Location location) {
        NBTStackHelper.setBlockPos(tag, keyName, location.getPos());
        NBTStackHelper.setWorldKey(tag, keyName + "D", location.dim);
        return tag;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        return NBTStackHelper.getLocation(stack.func_77978_p(), keyName);
    }

    public static Location getLocation(@Nullable CompoundNBT tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.func_74764_b(keyName + "D")).map(t -> {
            BlockPos pos = NBTStackHelper.getBlockPos(tag, keyName);
            RegistryKey<World> worldKey = NBTStackHelper.getWorldKey(tag, keyName + "D");
            if (!pos.equals((Object)Location.ORIGIN_POS) && worldKey != null) {
                return new Location(pos, worldKey);
            }
            return Location.ORIGIN;
        }).orElse(Location.ORIGIN);
    }

    public static ItemStack setWorldKey(ItemStack stack, String keyName, RegistryKey<World> worldKey) {
        NBTStackHelper.setWorldKey(stack.func_196082_o(), keyName, worldKey);
        return stack;
    }

    public static CompoundNBT setWorldKey(CompoundNBT tag, String keyName, RegistryKey<World> worldKey) {
        World.field_234917_f_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, worldKey).resultOrPartial(arg_0 -> ((Logger)ModTombstone.LOGGER).error(arg_0)).ifPresent(rl -> tag.func_218657_a(keyName, rl));
        return tag;
    }

    @Nullable
    public static RegistryKey<World> getWorldKey(ItemStack stack, String keyName) {
        return NBTStackHelper.getWorldKey(stack.func_77978_p(), keyName);
    }

    @Nullable
    public static RegistryKey<World> getWorldKey(@Nullable CompoundNBT tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.func_74764_b(keyName)).flatMap(t -> World.field_234917_f_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag.func_74781_a(keyName)).result()).orElse(null);
    }

    public static int getTimer(long actualTime, ItemStack stack, String keyName, int limit) {
        long endTime = NBTStackHelper.getLong(stack, keyName, 0L);
        if (endTime > 0L) {
            long leftTime = endTime - actualTime;
            if (leftTime > 0L) {
                if (leftTime > (long)limit) {
                    NBTStackHelper.setLong(stack, keyName, actualTime + (long)limit);
                    leftTime = limit;
                }
                return (int)leftTime;
            }
            NBTStackHelper.removeKeyName(stack, keyName);
        }
        return 0;
    }

    public static boolean hasTimer(long actualTime, ItemStack stack, String keyName, int limit) {
        return NBTStackHelper.getTimer(actualTime, stack, keyName, limit) > 0;
    }

    public static boolean removeLocation(ItemStack stack, String keyName) {
        return Stream.of("X", "Y", "Z", "D").filter(k -> NBTStackHelper.removeKeyName(stack, keyName + k)).count() == 4L;
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        CompoundNBT tag = stack.func_77978_p();
        boolean removed = false;
        if (tag != null && tag.func_74764_b(keyName)) {
            removed = true;
            tag.func_82580_o(keyName);
            if (tag.isEmpty()) {
                stack.func_77982_d(null);
            }
        }
        return removed;
    }

    public static List<EffectInstance> getEffectList(CompoundNBT tag, String keyName, Predicate<Effect> predic) {
        ArrayList<EffectInstance> effectInstances = new ArrayList<EffectInstance>();
        if (tag.func_150297_b(keyName, 9)) {
            ListNBT effectList = tag.func_150295_c(keyName, 10);
            for (int i = 0; i < effectList.size(); ++i) {
                EffectInstance effectInstance = NBTStackHelper.getEffect(effectList.func_150305_b(i), predic);
                if (effectInstance == null) continue;
                effectInstances.add(effectInstance);
            }
        }
        return effectInstances;
    }

    public static void setEffectlist(CompoundNBT tag, String keyName, Stream<EffectInstance> effectInstances) {
        ListNBT effectList = new ListNBT();
        effectInstances.forEach(effectInstance -> effectList.add((Object)NBTStackHelper.setEffect(new CompoundNBT(), effectInstance)));
        tag.func_218657_a(keyName, (INBT)effectList);
    }

    public static CompoundNBT setEffect(CompoundNBT tag, EffectInstance effectInstance) {
        effectInstance.func_82719_a(tag);
        return tag;
    }

    @Nullable
    public static EffectInstance getEffect(CompoundNBT tag, Predicate<Effect> predic) {
        EffectInstance effectInstance = EffectInstance.func_82722_b((CompoundNBT)tag);
        if (effectInstance != null && predic.test(effectInstance.func_188419_a())) {
            return effectInstance;
        }
        return null;
    }

    public static ListNBT getListOrCreate(CompoundNBT tag, String keyName) {
        if (tag.func_150297_b(keyName, 9)) {
            return tag.func_150295_c(keyName, 10);
        }
        ListNBT list = new ListNBT();
        tag.func_218657_a(keyName, (INBT)list);
        return list;
    }

    public static Optional<ListNBT> getListOrEmpty(ItemStack stack, String keyName) {
        return Optional.ofNullable(stack.func_77978_p()).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, keyName));
    }

    public static Optional<ListNBT> getListOrEmpty(CompoundNBT tag, String keyName) {
        return Optional.of(tag).filter(t -> t.func_150297_b(keyName, 9)).map(t -> t.func_150295_c(keyName, 10));
    }

    public static void fillPerksInMap(CompoundNBT tag, Map<Perk, Integer> perks) {
        if (tag.func_150297_b("perks", 9)) {
            ListNBT tagPerks = tag.func_150295_c("perks", 10);
            IntStream.range(0, tagPerks.size()).mapToObj(arg_0 -> ((ListNBT)tagPerks).func_150305_b(arg_0)).filter(tagPerk -> tagPerk.func_150297_b("id", 3) && tagPerk.func_150297_b("level", 3)).forEach(tagPerk -> {
                Perk perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"));
                if (perk != null && !perk.isDisabled(null)) {
                    perks.put(perk, Math.min(perk.getLevelMax(), tagPerk.func_74762_e("level")));
                }
            });
        }
    }

    public static void fillPerksInTag(Map<Perk, Integer> perks, CompoundNBT tag) {
        ListNBT tagPerks = new ListNBT();
        perks.forEach((perk, value) -> {
            if (perk != null && !perk.isDisabled(null)) {
                CompoundNBT tagPerk = new CompoundNBT();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)perk));
                tagPerk.func_74768_a("level", Math.min(perk.getLevelMax(), value));
                tagPerks.add((Object)tagPerk);
            }
        });
        tag.func_218657_a("perks", (INBT)tagPerks);
    }
}

