/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.particle.ParticleMarker;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class MarkerHandler {
    public static final MarkerHandler instance = new MarkerHandler();
    private boolean canRender;
    private boolean isFishingRod;
    private boolean inOpenWater;
    private Vector3d position;

    private MarkerHandler() {
    }

    public void update(Minecraft mc) {
        assert (mc.field_71439_g != null && mc.field_71441_e != null);
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        boolean bl = this.isFishingRod = stack.func_77973_b() == ModItems.fishing_rod_of_misadventure;
        this.canRender = (Boolean)ConfigTombstone.client.highlight.get() != false && (this.isFishingRod ? (Boolean)ConfigTombstone.client.showFishingMarker.get() != false && Optional.ofNullable(mc.field_71439_g.field_71104_cf).map(f -> f.field_190627_av == FishingBobberEntity.State.BOBBING).orElse(false) != false && TimeHelper.atInterval(TimeHelper.worldTicks(mc.field_71439_g.field_70170_p), 100) : ConfigTombstone.client.markerType.get() == ConfigTombstone.Client.MarkerType.BOX || TimeHelper.atInterval(TimeHelper.worldTicks(mc.field_71439_g.field_70170_p), 5));
        this.position = null;
        if (this.canRender) {
            if (this.isFishingRod) {
                assert (mc.field_71439_g.field_71104_cf != null);
                this.position = mc.field_71439_g.field_71104_cf.func_213303_ch();
                this.inOpenWater = InOpenWaterCondition.isOpenWaterAround((World)mc.field_71441_e, mc.field_71439_g.field_71104_cf.func_233580_cy_());
            } else {
                Location loc = stack.func_77973_b() == ModItems.grave_key ? ModItems.grave_key.getTombPos(stack) : (stack.func_77973_b() == ModItems.tablet_of_recall ? ModItems.tablet_of_recall.getTombPos(stack) : (ModItems.lost_tablet.isWakeUp(stack) ? ModItems.lost_tablet.getLocation(stack) : (stack.func_77973_b() == ModItems.villager_gift && (!ModItems.villager_gift.isInVillageRange((PlayerEntity)mc.field_71439_g, stack) || ModItems.villager_gift.isTargetFound(stack)) ? ModItems.villager_gift.getCurrentTarget(stack) : (stack.func_77973_b() == ModItems.seeker_rod && (!ModItems.seeker_rod.isInVillageRange((PlayerEntity)mc.field_71439_g, stack) || ModItems.seeker_rod.isTargetFound(stack)) ? ModItems.seeker_rod.getCurrentTarget(stack) : Location.ORIGIN))));
                if (!loc.isOrigin() && loc.isSameDimension(mc.field_71439_g.field_70170_p)) {
                    BlockPos pos = loc.getPos();
                    this.position = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                } else {
                    this.canRender = false;
                }
            }
        }
    }

    public void render(Minecraft mc, MatrixStack poseStack) {
        assert (mc.field_71439_g != null && mc.field_71441_e != null);
        if (this.canRender) {
            if (this.isFishingRod) {
                Optional.ofNullable(mc.field_71439_g.field_71104_cf).map(Entity::func_213303_ch).ifPresent(vec -> {
                    boolean inRange;
                    Vector3d vecCameraToLocation = vec.func_178788_d(mc.field_71460_t.func_215316_n().func_216785_c());
                    boolean bl = inRange = vecCameraToLocation.func_72433_c() < 50.0;
                    if (inRange) {
                        ParticleMarker particle = new ParticleMarker(mc.field_71441_e, vec.field_72450_a, vec.field_72448_b + 0.8, vec.field_72449_c, 0.0, 0.0, 0.0, 1.0f, new float[]{this.inOpenWater ? 0.0f : 1.0f, this.inOpenWater ? 1.0f : 0.0f, 1.0f});
                        particle.setFishing();
                        particle.func_187114_a(10);
                        mc.field_71452_i.func_78873_a((Particle)particle);
                    }
                });
                this.canRender = false;
            } else {
                float[] colors = Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f);
                if (ConfigTombstone.client.markerType.get() == ConfigTombstone.Client.MarkerType.BOX) {
                    MarkerHandler.createBox(mc, poseStack, this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c, colors);
                } else {
                    boolean isFarAway;
                    Vector3d vec2 = new Vector3d(this.position.field_72450_a + 0.5, this.position.field_72448_b + 0.8, this.position.field_72449_c + 0.5);
                    Vector3d vecCameraToLocation = vec2.func_178788_d(mc.field_71460_t.func_215316_n().func_216785_c());
                    boolean bl = isFarAway = vecCameraToLocation.func_72433_c() > 10.0;
                    if (isFarAway) {
                        vec2 = mc.field_71460_t.func_215316_n().func_216785_c().func_178787_e(vecCameraToLocation.func_72432_b().func_186678_a(10.0));
                    }
                    MarkerHandler.spawnParticle(mc, vec2, isFarAway ? 1.0f : 0.3f, colors);
                    this.canRender = false;
                }
            }
        }
    }

    private static void spawnParticle(Minecraft mc, Vector3d vec3, float scale, float[] colors) {
        double horizontalOffset = 0.25;
        assert (mc.field_71441_e != null);
        double yOffset = (Helper.RANDOM.nextDouble() - 0.5) * 2.0;
        ParticleMarker particle = new ParticleMarker(mc.field_71441_e, vec3.field_72450_a + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, vec3.field_72448_b + yOffset * 0.5, vec3.field_72449_c + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, 0.0, (double)(yOffset < 0.5 ? -1 : 1) * Helper.RANDOM.nextDouble() * 0.01, 0.0, scale, colors);
        mc.field_71452_i.func_78873_a((Particle)particle);
    }

    private static void createBox(Minecraft mc, MatrixStack matrixStack, double x, double y, double z, float[] colors) {
        Vector3d vec = new Vector3d(x, y, z).func_178788_d(mc.field_71460_t.func_215316_n().func_216785_c());
        if (vec.func_72438_d(Vector3d.field_186680_a) > 200.0) {
            vec = vec.func_72432_b().func_186678_a(200.0);
        }
        Vector3d vec1 = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        Vector3d vec2 = new Vector3d(vec.field_72450_a + 1.0, vec.field_72448_b + 1.0, vec.field_72449_c + 1.0);
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        matrixStack.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderSystem.color4f((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        RenderSystem.lineWidth((float)2.5f);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec2.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec2.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec2.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec2.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec2.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec2.field_72448_b, vec1.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c, colors);
        MarkerHandler.makeVertex(renderer, matrixStack.func_227866_c_(), vec1.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, colors);
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void makeVertex(BufferBuilder bufferbuilder, MatrixStack.Entry pose, double x, double y, double z, float[] colors) {
        bufferbuilder.func_227888_a_(pose.func_227870_a_(), (float)x, (float)y, (float)z).func_227885_a_(colors[0], colors[1], colors[2], 1.0f).func_227887_a_(pose.func_227872_b_(), 1.0f, 1.0f, 1.0f).func_181675_d();
    }
}

