/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTriggers;

public class EntityHelper {
    private static final String SHADOW_STEP_COOLDOWN_NBT_LONG = "shadow_step_cooldown";

    public static int getShadowStepLevel(PlayerEntity player) {
        boolean enabled;
        boolean bl = enabled = (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentShadowStep.get() != false && ((Boolean)SharedConfigTombstone.enchantments.nerfShadowStepForceSneak.get() == false || player.func_226273_bm_());
        if (!enabled) {
            return 0;
        }
        ItemStack shadowStepStack = player.func_184582_a(EquipmentSlotType.FEET);
        int shadowStepLevel = EnchantHelper.getEnchantmentLevel(ModEnchantments.shadow_step, shadowStepStack);
        if (shadowStepLevel == 0 || NBTStackHelper.hasTimer(TimeHelper.worldTicks(player.field_70170_p), shadowStepStack, SHADOW_STEP_COOLDOWN_NBT_LONG, 200)) {
            return 0;
        }
        return shadowStepLevel;
    }

    public static void setShadowStepCooldown(PlayerEntity player) {
        NBTStackHelper.setLong(player.func_184582_a(EquipmentSlotType.FEET), SHADOW_STEP_COOLDOWN_NBT_LONG, TimeHelper.worldTicks(player.field_70170_p) + 200L);
    }

    public static int getCurseOfBonesLevel(LivingEntity entity) {
        return EnchantHelper.getEnchantmentLevel(ModEnchantments.curse_of_bones, entity.func_184582_a(EquipmentSlotType.CHEST));
    }

    public static boolean isValidPlayer(@Nullable ICommandSource sender) {
        return sender instanceof PlayerEntity && !(sender instanceof FakePlayer);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof PlayerEntity && !(entity instanceof FakePlayer);
    }

    public static boolean isValidServerPlayer(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && entity.field_70170_p != null && !entity.field_70170_p.func_201670_d();
    }

    public static boolean isValidServerPlayer(@Nullable PlayerEntity entity) {
        return EntityHelper.isValidPlayer(entity) && entity.field_70170_p != null && !entity.field_70170_p.func_201670_d();
    }

    public static boolean isValidPlayer(@Nullable PlayerEntity player) {
        return player != null && !EntityHelper.isFakePlayer(player);
    }

    public static boolean isFakePlayer(PlayerEntity player) {
        return player instanceof FakePlayer;
    }

    public static boolean isKilledByOtherPlayer(PlayerEntity player, DamageSource source) {
        return EntityHelper.isValidPlayer(source.func_76346_g()) && !player.equals((Object)source.func_76346_g());
    }

    public static Optional<GlobalPos> getHomeLocation(LivingEntity entity) {
        try {
            if (entity.func_213375_cj().func_218191_a(MemoryModuleType.field_220941_b)) {
                return entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220941_b);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static void setPlayerXp(PlayerEntity player, int amount) {
        if (amount <= 0) {
            return;
        }
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
        player.field_71106_cc += (float)amount / (float)player.func_71050_bK();
        player.field_71067_cb += amount;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ++player.field_71068_ca;
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static Pair<Integer, Float> getPlayerXpPair(int experienceTotal) {
        float aExperience;
        if (experienceTotal <= 0) {
            return Pair.of((Object)0, (Object)Float.valueOf(0.0f));
        }
        int aExperienceLevel = 0;
        for (aExperience = (float)experienceTotal / (float)EntityHelper.xpBarCap(aExperienceLevel); aExperience >= 1.0f; aExperience /= (float)EntityHelper.xpBarCap(++aExperienceLevel)) {
            aExperience = (aExperience - 1.0f) * (float)EntityHelper.xpBarCap(aExperienceLevel);
        }
        return Pair.of((Object)aExperienceLevel, (Object)Float.valueOf(aExperience));
    }

    public static int getPlayerTotalXp(PlayerEntity player) {
        return EntityHelper.getPlayerTotalXp(player.field_71068_ca, player.field_71106_cc);
    }

    private static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal = level < 17 ? level * level + 6 * level : (level < 32 ? (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0) : (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0));
        experienceTotal = (int)((double)experienceTotal + Math.floor((float)EntityHelper.xpBarCap(level) * bar));
        return experienceTotal;
    }

    private static int xpBarCap(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static boolean noGlobalItemCooldown(@Nullable PlayerEntity player, Item item) {
        return EntityHelper.getGlobalItemCooldownPercent(player, item) <= 0.0f;
    }

    public static boolean noGlobalItemCooldown(@Nullable PlayerEntity player, ItemStack stack) {
        return EntityHelper.noGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static boolean hasGlobalItemCooldown(@Nullable PlayerEntity player, Item item) {
        return EntityHelper.getGlobalItemCooldownPercent(player, item) > 0.0f;
    }

    public static boolean hasGlobalItemCooldown(@Nullable PlayerEntity player, ItemStack stack) {
        return EntityHelper.hasGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static void setGlobalItemCooldown(PlayerEntity player, Item item, int ticks) {
        player.func_184811_cZ().func_185145_a(item, ticks);
    }

    public static void setGlobalItemCooldown(PlayerEntity player, ItemStack stack, int ticks) {
        EntityHelper.setGlobalItemCooldown(player, stack.func_77973_b(), ticks);
    }

    public static void removeGlobalItemCooldown(@Nullable PlayerEntity player, Item item) {
        Optional.ofNullable(player).ifPresent(p -> player.func_184811_cZ().func_185145_a(item, 0));
    }

    public static float getGlobalItemCooldownPercent(@Nullable PlayerEntity player, Item item) {
        return Optional.ofNullable(player).map(p -> Float.valueOf(p.func_184811_cZ().func_185143_a(item, 0.0f))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static void applyKillResult(DamageSource damageSource, LivingEntity killedEntity) {
        if (EntityHelper.isValidServerPlayer(damageSource.func_76346_g())) {
            ServerPlayerEntity player = (ServerPlayerEntity)damageSource.func_76346_g();
            assert (player != null);
            if (!CompatibilityMinecolonies.instance.applyKillResult(player, killedEntity.func_200600_R())) {
                if (killedEntity instanceof AbstractVillagerEntity) {
                    EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillVillager.get());
                    ModTriggers.KILL_ENOUGH_VILLAGER.trigger(player);
                } else if (EntityTypeTags.field_219765_b.func_230235_a_((Object)killedEntity.func_200600_R()) || killedEntity instanceof ZombieEntity && killedEntity.getPersistentData().func_74767_n("siege") || killedEntity instanceof PhantomEntity) {
                    EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillRaider.get());
                    ModTriggers.KILL_ENOUGH_RAIDER.trigger(player);
                }
            }
            if (EntityHelper.isUndead(killedEntity)) {
                ModTriggers.KILL_ENOUGH_UNDEAD.trigger(player);
                if (EntityHelper.isBoss(killedEntity)) {
                    ModTriggers.KILL_UNDEAD_BOSS.trigger(player);
                }
            }
        }
    }

    public static long getKnowledge(PlayerEntity player) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getKnowledge).orElse(0L);
    }

    public static void addKnowledge(ServerPlayerEntity player, long points) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.addKnowledgeAndSync(player, points));
    }

    public static void removeKnowledge(ServerPlayerEntity player, long points) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.removeKnowledgeAndSync(player, points));
    }

    public static void addAlignment(ServerPlayerEntity player, int amount) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.addAlignmentAndSync(player, amount));
    }

    public static boolean isBadAlignment(PlayerEntity player) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getAlignmentLevel() < 0).orElse(false);
    }

    public static int getPerkLevelWithBonus(@Nullable PlayerEntity player, @Nullable Perk perk) {
        return player == null ? 0 : player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getPerkLevelWithBonus(player, perk)).orElse(0);
    }

    public static int getKnowledgeForPerkLevel(int perkLevel) {
        int perkScale = (Integer)SharedConfigTombstone.general.perkProgressionScale.get();
        return perkLevel * perkScale - perkScale + 1;
    }

    public static int getPerkLevelMaxForKnowledge(int knowledgeLevel) {
        int perkScale = (Integer)SharedConfigTombstone.general.perkProgressionScale.get();
        return (knowledgeLevel + perkScale - 1) / perkScale;
    }

    public static void syncTBCapability(ServerPlayerEntity player, boolean checked) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
            if (checked) {
                int totalPerkPoints = cap.getTotalPerkPoints();
                int limit = EntityHelper.getPerkLevelMaxForKnowledge(totalPerkPoints);
                boolean valid = true;
                Iterator<Map.Entry<Perk, Integer>> it = cap.getPerks().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (!valid || Helper.isDisabledPerk(entry.getKey(), (PlayerEntity)player)) {
                        it.remove();
                        continue;
                    }
                    int maxPerkLevel = Math.min(limit, entry.getKey().getLevelMax());
                    if (entry.getValue() > maxPerkLevel) {
                        entry.setValue(maxPerkLevel);
                    }
                    for (int i = 1; i <= entry.getValue() && valid; ++i) {
                        int cost = entry.getKey().getCost(i);
                        if (cost <= totalPerkPoints) {
                            totalPerkPoints -= cost;
                            continue;
                        }
                        valid = false;
                        if (i > 1) {
                            entry.setValue(i - 1);
                            continue;
                        }
                        it.remove();
                    }
                }
            }
            cap.syncAll(player);
        });
    }

    public static CompoundNBT getPersistentTag(PlayerEntity player) {
        CompoundNBT persistantData = player.getPersistentData();
        if (persistantData.func_150297_b("PlayerPersisted", 10)) {
            return persistantData.func_74775_l("PlayerPersisted");
        }
        CompoundNBT persistantTag = new CompoundNBT();
        persistantData.func_218657_a("PlayerPersisted", (INBT)persistantTag);
        return persistantTag;
    }

    public static String getRegistryString(@Nullable Entity entity) {
        return entity == null ? "" : EntityHelper.getRegistryString(entity.func_200600_R());
    }

    public static String getRegistryString(@Nullable EntityType<?> entityType) {
        return Optional.ofNullable(entityType).map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).orElse("");
    }

    public static void writePlayerData(MinecraftServer server, PlayerEntity player) {
        server.func_184103_al().field_72412_k.func_237335_a_(player);
    }

    public static void loadPlayerData(MinecraftServer server, PlayerEntity player) {
        server.func_184103_al().field_72412_k.func_237336_b_(player);
    }

    @Nullable
    public static ServerPlayerEntity getOfflinePlayer(MinecraftServer server, UUID id) {
        GameProfile profil = EntityHelper.getGameProfile(server, id);
        if (profil != null) {
            ServerPlayerEntity player = server.func_184103_al().func_148545_a(profil);
            EntityHelper.loadPlayerData(server, (PlayerEntity)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static ServerPlayerEntity getOfflinePlayer(MinecraftServer server, String playerName) {
        GameProfile profil = EntityHelper.getGameProfile(server, playerName);
        if (profil != null) {
            ServerPlayerEntity player = server.func_184103_al().func_148545_a(profil);
            EntityHelper.loadPlayerData(server, (PlayerEntity)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, UUID id) {
        return server.func_152358_ax().func_152652_a(id);
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        PlayerProfileCache.ProfileEntry entry = (PlayerProfileCache.ProfileEntry)server.func_152358_ax().field_152661_c.get(playerName.toLowerCase(Locale.US));
        if (entry != null) {
            return entry.func_152668_a();
        }
        return null;
    }

    public static boolean isUndead(LivingEntity entity) {
        return entity.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    public static boolean isBoss(LivingEntity entity) {
        return entity.func_233638_c_(Attributes.field_233818_a_) >= (double)((Integer)ConfigTombstone.loot.undeadBossLifeForDrop.get()).intValue() && entity instanceof IMob && !entity.func_184222_aU();
    }

    public static boolean targetAnEnemy(LivingEntity entity) {
        return entity instanceof MobEntity && ((MobEntity)entity).field_70696_bz instanceof IMob;
    }
}

